package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 根据分类id查询分类名称
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryTheClassificationNameBasedOnTheClassificationIDService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据分类id查询分类名称";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyTagAggregateService surveyTagAggregateService;

    /**
    * 根据分类id查询分类名称接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryTheClassificationNameBasedOnTheClassificationIDDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryTheClassificationNameBasedOnTheClassificationIDBO bo = new QueryTheClassificationNameBasedOnTheClassificationIDBO();
        if (Objects.isNull(form)) {
            form = new QueryTheClassificationNameBasedOnTheClassificationIDDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"classificationName",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("classificationName",boMap.get("classificationName"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryTheClassificationNameBasedOnTheClassificationIDBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryTheClassificationNameBasedOnTheClassificationIDBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, QueryTheClassificationNameBasedOnTheClassificationIDBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_ufRX==");
        //调用数据查询
        QueryTheClassificationNameBasedOnTheClassificationIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveyTag vo = surveyTagAggregateService.dataQuery_ufRX(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryTheClassificationNameBasedOnTheClassificationIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryTheClassificationNameBasedOnTheClassificationIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String namedwppt0 = bo.getDataQuery().getName();
        bo.setClassificationName(namedwppt0);
        endEvent(paramsJsonContext, executeBO);
    }

}