package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 根据回答id查询问题信息
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryQuestionInformationBasedOnAnswerIDService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据回答id查询问题信息";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyInfoAggregateService surveyInfoAggregateService;

    /**
    * 根据回答id查询问题信息接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryQuestionInformationBasedOnAnswerIDDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryQuestionInformationBasedOnAnswerIDBO bo = new QueryQuestionInformationBasedOnAnswerIDBO();
        if (Objects.isNull(form)) {
            form = new QueryQuestionInformationBasedOnAnswerIDDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算
        //数据查询-问题详情
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"problemInformation","attachmentInformation",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("problemInformation",boMap.get("problemInformation"));
                vo.put("attachmentInformation",boMap.get("attachmentInformation"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryQuestionInformationBasedOnAnswerIDBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        operation(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryQuestionInformationBasedOnAnswerIDBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 运算
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operation(JSONObject paramsJsonContext, QueryQuestionInformationBasedOnAnswerIDBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryQuestionInformationBasedOnAnswerIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_biz_flow_v2_input_param_U_95997ed438c748a1885f7715d0f3eec7_u;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_95997ed438c748a1885f7715d0f3eec7_u";
        String bindType0 = "BigInteger";
        Long bindValue0 = bo.getAnswerID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperation(vo);
        log.debug("流程名称：{},方法名称: 运算,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQueryProblemDetails(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryQuestionInformationBasedOnAnswerIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryQuestionInformationBasedOnAnswerIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Object dataQueryProblemDetailsbgzcy0 = bo.getDataQueryProblemDetails();
        bo.setProblemInformation(dataQueryProblemDetailsbgzcy0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-问题详情
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryProblemDetails(JSONObject paramsJsonContext, QueryQuestionInformationBasedOnAnswerIDBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-问题详情==taskIdentifier：dataQueryProblemDetails==damMethod：dataQuery_kBPx==");
        //调用数据查询
        QueryQuestionInformationBasedOnAnswerIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-问题详情,输入参数: {}",processName,JSON.toJSONString(bo));
        DataqueryKbpxBO vo = surveyInfoAggregateService.dataQuery_kBPx(paramsJsonContext,bo);
        bo.setDataQueryProblemDetails(vo);
        log.debug("流程名称：{},方法名称: 数据查询-问题详情,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

}