package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 根据计划id查询计划信息
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryPlanInformationBasedOnPlanIDService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据计划id查询计划信息";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanAggregateService surveyPlanAggregateService;
    @Autowired
    private GatewayMatchService gatewayMatchService;    @Autowired
    private SurveySignAggregateService surveySignAggregateService;
    /**
    * 根据计划id查询计划信息接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryPlanInformationBasedOnPlanIDDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryPlanInformationBasedOnPlanIDBO bo = new QueryPlanInformationBasedOnPlanIDBO();
        if (Objects.isNull(form)) {
            form = new QueryPlanInformationBasedOnPlanIDDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询-踏勘计划
        //运算-查勘反馈id
        //运算-问卷id
        //运算-阶段
        //参数赋值
        //数据查询-签到信息
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"activityName","surveyStage","surveyFreq","surveySts0Incomplete1InProgress2Completed3TasksClosed","signatureOfAccountMgr","signatureOfTheResponsiblePersonOfTheOrganizer","chkInOrNot","venueName","surveyFeedbackID","questionnaireID",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("activityName",boMap.get("activityName"));
                vo.put("surveyStage",boMap.get("surveyStage"));
                vo.put("surveyFreq",boMap.get("surveyFreq"));
                vo.put("surveySts0Incomplete1InProgress2Completed3TasksClosed",boMap.get("surveySts0Incomplete1InProgress2Completed3TasksClosed"));
                vo.put("signatureOfAccountMgr",boMap.get("signatureOfAccountMgr"));
                vo.put("signatureOfTheResponsiblePersonOfTheOrganizer",boMap.get("signatureOfTheResponsiblePersonOfTheOrganizer"));
                vo.put("chkInOrNot",boMap.get("chkInOrNot"));
                vo.put("venueName",boMap.get("venueName"));
                vo.put("surveyFeedbackID",boMap.get("surveyFeedbackID"));
                vo.put("questionnaireID",boMap.get("questionnaireID"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQuerySurveyPlan(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询-踏勘计划
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuerySurveyPlan(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-踏勘计划==taskIdentifier：dataQuerySurveyPlan==damMethod：dataQuery_gsTW==");
        //调用数据查询
        QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-踏勘计划,输入参数: {}",processName,JSON.toJSONString(bo));
        DataqueryGstwBO vo = surveyPlanAggregateService.dataQuery_gsTW(paramsJsonContext,bo);
        bo.setDataQuerySurveyPlan(vo);
        log.debug("流程名称：{},方法名称: 数据查询-踏勘计划,输出参数: {}",processName,JSON.toJSONString(vo));
        calculationSurveyFeedbackID(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String nameihcfc0 = bo.getDataQuerySurveyPlan().getName();
        bo.setActivityName(nameihcfc0);
        Integer calculationStagehrjik1 = bo.getCalculationStage();
        bo.setSurveyStage(calculationStagehrjik1);
        Integer timetgura2 = bo.getDataQuerySurveyPlan().getTime();
        bo.setSurveyFreq(timetgura2);
        String taskStatusmtvml3 = bo.getDataQuerySurveyPlan().getTaskStatus();
        bo.setSurveySts0Incomplete1InProgress2Completed3TasksClosed(taskStatusmtvml3);
        String signImgPathhkjto4 = bo.getDataQuerySurveyPlan().getSignImgPath();
        bo.setSignatureOfAccountMgr(signImgPathhkjto4);
        String purveyorSignPathrtnpu5 = bo.getDataQuerySurveyPlan().getPurveyorSignPath();
        bo.setSignatureOfTheResponsiblePersonOfTheOrganizer(purveyorSignPathrtnpu5);
        String venueNamekmrbd6 = bo.getDataQuerySurveyPlan().getVenueName();
        bo.setVenueName(venueNamekmrbd6);
        String calculationSurveyFeedbackIDunpmk7 = bo.getCalculationSurveyFeedbackID();
        bo.setSurveyFeedbackID(calculationSurveyFeedbackIDunpmk7);
        String calculationQuestionnaireIDyfrww8 = bo.getCalculationQuestionnaireID();
        bo.setQuestionnaireID(calculationQuestionnaireIDyfrww8);
        dataQueryChkInInformation(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_ehCl(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Boolean booleanVNoykaon0 = ElementConstants.booleanVNo;
        bo.setChkInOrNot(booleanVNoykaon0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_zGLa(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Boolean booleanVIsgocgp0 = ElementConstants.booleanVIs;
        bo.setChkInOrNot(booleanVIsgocgp0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 运算-查勘反馈id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationSurveyFeedbackID(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-查勘反馈id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nJSON.stringify(u_biz_flow_v2_process_output_param_U_cffeae40027b41c6882fe930dd3815ca_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_process_output_param_U_cffeae40027b41c6882fe930dd3815ca_u";
        String bindType0 = "BigInteger";
        Long bindValue0 = bo.getDataQuerySurveyPlan().getFeedbackId();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setCalculationSurveyFeedbackID(vo);
        log.debug("流程名称：{},方法名称: 运算-查勘反馈id,输出参数: {}",processName,JSON.toJSONString(vo));
        calculationQuestionnaireID(paramsJsonContext, executeBO);
    }

    /**
    * 运算-问卷id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationQuestionnaireID(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-问卷id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nJSON.stringify(u_biz_flow_v2_process_output_param_U_d21b2f472e384c1d8f51955cf676498a_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_process_output_param_U_d21b2f472e384c1d8f51955cf676498a_u";
        String bindType0 = "BigInteger";
        Long bindValue0 = bo.getDataQuerySurveyPlan().getQuestionnaireId();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setCalculationQuestionnaireID(vo);
        log.debug("流程名称：{},方法名称: 运算-问卷id,输出参数: {}",processName,JSON.toJSONString(vo));
        calculationStage(paramsJsonContext, executeBO);
    }

    /**
    * 运算-阶段
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationStage(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-阶段,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_biz_flow_v2_process_output_param_U_2ab12229075b45e786bb87cb60b00ae8_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_process_output_param_U_2ab12229075b45e786bb87cb60b00ae8_u";
        String bindType0 = "String";
        String bindValue0 = bo.getDataQuerySurveyPlan().getSurveyStep();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setCalculationStage(vo);
        log.debug("流程名称：{},方法名称: 运算-阶段,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchParamAssignment_zGLa(paramsJsonContext, executeBO)){
            paramAssignment_zGLa(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment_ehCl(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchParamAssignment_zGLa(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Object dataQueryChkInInformation = bo.getDataQueryChkInInformation();
            boolean matchState = (((ObjectUtils.isNotEmpty(dataQueryChkInInformation))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 数据查询-签到信息
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryChkInInformation(JSONObject paramsJsonContext, QueryPlanInformationBasedOnPlanIDBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-签到信息==taskIdentifier：dataQueryChkInInformation==damMethod：dataQuery_vyhD==");
        //调用数据查询
        QueryPlanInformationBasedOnPlanIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-签到信息,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveySign vo = surveySignAggregateService.dataQuery_vyhD(paramsJsonContext,bo);
        bo.setDataQueryChkInInformation(vo);
        log.debug("流程名称：{},方法名称: 数据查询-签到信息,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

}