package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 根据用户id查询进行中的任务列
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryOngoingTskColumnsBasedOnUserIDService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据用户id查询进行中的任务列";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyTaskAggregateService surveyTaskAggregateService;

    /**
    * 根据用户id查询进行中的任务列接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryOngoingTskColumnsBasedOnUserIDDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryOngoingTskColumnsBasedOnUserIDBO bo = new QueryOngoingTskColumnsBasedOnUserIDBO();
        if (Objects.isNull(form)) {
            form = new QueryOngoingTskColumnsBasedOnUserIDDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算-用户id
        //数据查询
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"tskLstData",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("tskLstData",boMap.get("tskLstData"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryOngoingTskColumnsBasedOnUserIDBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        calculationUserID(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryOngoingTskColumnsBasedOnUserIDBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, QueryOngoingTskColumnsBasedOnUserIDBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_EQSh==");
        //调用数据查询
        QueryOngoingTskColumnsBasedOnUserIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveyTask> vo = surveyTaskAggregateService.dataQuery_EQSh(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryOngoingTskColumnsBasedOnUserIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryOngoingTskColumnsBasedOnUserIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List dataQuerywcefx0 = bo.getDataQuery();
        bo.setTskLstData(dataQuerywcefx0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 运算-用户id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationUserID(JSONObject paramsJsonContext, QueryOngoingTskColumnsBasedOnUserIDBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryOngoingTskColumnsBasedOnUserIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-用户id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "1;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setCalculationUserID(vo);
        log.debug("流程名称：{},方法名称: 运算-用户id,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQuery(paramsJsonContext, executeBO);
    }

}