package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import org.springframework.scheduling.annotation.Async;
/**
* 根据任务id查询最大计划次数
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryMaxNumOfPlansBasedOnTskIDService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据任务id查询最大计划次数";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanAggregateService surveyPlanAggregateService;
    @Autowired
    private AcquiringTimesService acquiringTimesService;
    /**
    * 根据任务id查询最大计划次数接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryMaxNumOfPlansBasedOnTskIDDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryMaxNumOfPlansBasedOnTskIDBO bo = new QueryMaxNumOfPlansBasedOnTskIDBO();
        if (Objects.isNull(form)) {
            form = new QueryMaxNumOfPlansBasedOnTskIDDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询-倒序查询次数
        //代码块
        //同步引用流程
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"freq",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("freq",boMap.get("freq"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryMaxNumOfPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQueryNumOfRevsOrderQueries(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryMaxNumOfPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询-倒序查询次数
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryNumOfRevsOrderQueries(JSONObject paramsJsonContext, QueryMaxNumOfPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-倒序查询次数==taskIdentifier：dataQueryNumOfRevsOrderQueries==damMethod：dataQuery_okFg==");
        //调用数据查询
        QueryMaxNumOfPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-倒序查询次数,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveyPlan> vo = surveyPlanAggregateService.dataQuery_okFg(paramsJsonContext,bo);
        bo.setDataQueryNumOfRevsOrderQueries(vo);
        log.debug("流程名称：{},方法名称: 数据查询-倒序查询次数,输出参数: {}",processName,JSON.toJSONString(vo));
        codeBlk(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryMaxNumOfPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryMaxNumOfPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Integer oCntyfvex0 = bo.getSynchronousRefProc().getOCnt();
        bo.setFreq(oCntyfvex0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 同步引用流程
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronousRefProc(JSONObject paramsJsonContext, QueryMaxNumOfPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        QueryMaxNumOfPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                Integer time0 = bo.getCodeBlk().getTime();
                jsonObjectNewParam.put("inCnt", time0);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronousRefProcExecSub(BeanUtil.mapToBean(jsonObjectNewParam, AcquiringTimesDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        AcquiringTimesVO vo = JSON.parseObject(JSON.toJSONString(voObj),AcquiringTimesVO.class);
        bo.setSynchronousRefProc(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    JSONObject synchronousRefProcExecSub(AcquiringTimesDTO form) throws BusinessException {
        return acquiringTimesService.processMainExecute(form);
    }

    /**
    * 代码块
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void codeBlk(JSONObject paramsJsonContext, QueryMaxNumOfPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行代码块方法=======");
        QueryMaxNumOfPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 代码块,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJson = new JSONObject();
        List dataQueryNumOfRevsOrderQueries0 = bo.getDataQueryNumOfRevsOrderQueries();
        paramsJson.put("timeList", dataQueryNumOfRevsOrderQueries0);
        Object vo = codeBlkCodeBlock(paramsJson);
        QueryMaxNumOfPlansBasedOnTskIDCodeBlk voObj = JSON.parseObject(JSON.toJSONString(vo),QueryMaxNumOfPlansBasedOnTskIDCodeBlk.class);
        bo.setCodeBlk(voObj);
        synchronousRefProc(paramsJsonContext, executeBO);
    }

    /**
     * 代码块执行代码块方法体
     * @param params
     * param timeList 踏勘次数列表
     * @return 返回值
     */
    public Object codeBlkCodeBlock(JSONObject params) throws BusinessException{
        //自定义代码块逻辑
        

List<Object> timeList = params.getList("timeList",Object.class);
return timeList.get(0);












    }

}