package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 根据阶段查询固定问题列表
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryFixedProblemLstByStageService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据阶段查询固定问题列表";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private QueryTheNumOfIssuesByStageService queryTheNumOfIssuesByStageService;
    @Autowired
    private GatewayMatchService gatewayMatchService;    @Autowired
    private BaseFixedIssueAggregateService baseFixedIssueAggregateService;
    /**
    * 根据阶段查询固定问题列表接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryFixedProblemLstByStageDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryFixedProblemLstByStageBO bo = new QueryFixedProblemLstByStageBO();
        if (Objects.isNull(form)) {
            form = new QueryFixedProblemLstByStageDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //同步引用流程
        //阶段问题条数等于0
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"dataLst",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("dataLst",boMap.get("dataLst"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        synchronousRefProc(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 同步引用流程
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronousRefProc(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        QueryFixedProblemLstByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                String siteType0 = bo.getSiteType();
                jsonObjectNewParam.put("siteType", siteType0);
                String activityType1 = bo.getActivityType();
                jsonObjectNewParam.put("activityType", activityType1);
                Integer stageV1232 = bo.getStageV123();
                jsonObjectNewParam.put("stageV123", stageV1232);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronousRefProcExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryTheNumOfIssuesByStageDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryTheNumOfIssuesByStageVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryTheNumOfIssuesByStageVO.class);
        bo.setSynchronousRefProc(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程,输出参数: {}",processName,JSON.toJSONString(vo));
        theNumOfStageQuestionsIsEqTo0(paramsJsonContext, executeBO);
    }

    JSONObject synchronousRefProcExecSub(QueryTheNumOfIssuesByStageDTO form) throws BusinessException {
        return queryTheNumOfIssuesByStageService.processMainExecute(form);
    }

    /**
    * 阶段问题条数等于0
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void theNumOfStageQuestionsIsEqTo0(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "阶段问题条数等于0";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(theNumOfStageQuestionsIsEqTo0DataQuery(paramsJsonContext, executeBO)){
            generalProblemQuery(paramsJsonContext, executeBO);
        }
        else {
            ifTheVenueIs2Or4(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean theNumOfStageQuestionsIsEqTo0DataQuery(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            QueryFixedProblemLstByStageBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Long quantity = bo.getSynchronousRefProc().getQuantity();
            boolean matchState = (((quantity.equals("0"))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 通用问题查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void generalProblemQuery(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：通用问题查询==taskIdentifier：generalProblemQuery==damMethod：dataQuery_lINF==");
        //调用数据查询
        QueryFixedProblemLstByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 通用问题查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<BaseFixedIssue> vo = baseFixedIssueAggregateService.dataQuery_lINF(paramsJsonContext,bo);
        bo.setGeneralProblemQuery(vo);
        log.debug("流程名称：{},方法名称: 通用问题查询,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryFixedProblemLstByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List generalProblemQuerymmevo0 = bo.getGeneralProblemQuery();
        bo.setDataLst(generalProblemQuerymmevo0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 如果场地为2或者4
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void ifTheVenueIs2Or4(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "如果场地为2或者4";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(ifTheVenueIs2Or4ParamAssignment_IoWY(paramsJsonContext, executeBO)){
            paramAssignment_IoWY(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment_EbpD(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean ifTheVenueIs2Or4ParamAssignment_IoWY(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            QueryFixedProblemLstByStageBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            String siteType = bo.getSiteType();
            String siteTypexomsd = bo.getSiteType();
            boolean matchState = (((siteType.equals("2"))))||(((siteTypexomsd.equals("4"))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_IoWY(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryFixedProblemLstByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String bkfih0 = "1";
        bo.setAddrType(bkfih0);
        queryBasedOnVenueAndActivityType(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_EbpD(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryFixedProblemLstByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String siteTypehfmgd0 = bo.getSiteType();
        bo.setAddrType(siteTypehfmgd0);
        queryBasedOnVenueAndActivityType(paramsJsonContext, executeBO);
    }

    /**
    * 根据场地及活动类型查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void queryBasedOnVenueAndActivityType(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：根据场地及活动类型查询==taskIdentifier：queryBasedOnVenueAndActivityType==damMethod：dataQuery_FuxV==");
        //调用数据查询
        QueryFixedProblemLstByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 根据场地及活动类型查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<BaseFixedIssue> vo = baseFixedIssueAggregateService.dataQuery_FuxV(paramsJsonContext,bo);
        bo.setQueryBasedOnVenueAndActivityType(vo);
        log.debug("流程名称：{},方法名称: 根据场地及活动类型查询,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment_XwXr(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_XwXr(JSONObject paramsJsonContext, QueryFixedProblemLstByStageBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryFixedProblemLstByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List queryBasedOnVenueAndActivityTypeimxwb0 = bo.getQueryBasedOnVenueAndActivityType();
        bo.setDataLst(queryBasedOnVenueAndActivityTypeimxwb0);
        endEvent(paramsJsonContext, executeBO);
    }

}