package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.da.service.SurveyExpertService;
import com.wlos.app.bo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.vo.*;
/**
* 计划绑定专家
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class PlanToBindExpertsService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "计划绑定专家";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private GatewayMatchService gatewayMatchService;
    @Autowired
    private SrchForApprovedExpertsBasedOnTasksAndStagesService srchForApprovedExpertsBasedOnTasksAndStagesService;    @Autowired
    private SurveyExpertService surveyExpertService;    @Autowired
    private SurveyExpertAggregateService surveyExpertAggregateService;
    /**
    * 计划绑定专家接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(PlanToBindExpertsDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        PlanToBindExpertsBO bo = new PlanToBindExpertsBO();
        if (Objects.isNull(form)) {
            form = new PlanToBindExpertsDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //同步引用流程
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"expert",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("expert",boMap.get("expert"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        synchronousRefProc(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchDataQuerySurveyExpertRecords(paramsJsonContext, executeBO)){
            dataQuerySurveyExpertRecords(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchDataQuerySurveyExpertRecords(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            PlanToBindExpertsBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Object expertApprovalInformation = bo.getSynchronousRefProc().getExpertApprovalInformation();
            boolean matchState = (((ObjectUtils.isNotEmpty(expertApprovalInformation))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        PlanToBindExpertsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String soycx0 = "无";
        bo.setExpert(soycx0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 同步引用流程
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronousRefProc(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        PlanToBindExpertsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                Long tskID0 = bo.getTskID();
                jsonObjectNewParam.put("tskID", tskID0);
                Integer stage1 = bo.getStage();
                jsonObjectNewParam.put("stage", stage1);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronousRefProcExecSub(BeanUtil.mapToBean(jsonObjectNewParam, SrchForApprovedExpertsBasedOnTasksAndStagesDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        SrchForApprovedExpertsBasedOnTasksAndStagesVO vo = JSON.parseObject(JSON.toJSONString(voObj),SrchForApprovedExpertsBasedOnTasksAndStagesVO.class);
        bo.setSynchronousRefProc(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

    JSONObject synchronousRefProcExecSub(SrchForApprovedExpertsBasedOnTasksAndStagesDTO form) throws BusinessException {
        return srchForApprovedExpertsBasedOnTasksAndStagesService.processMainExecute(form);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_iqKP(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        PlanToBindExpertsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String realNamepjebb0 = bo.getSynchronousRefProc().getExpertApprovalInformation().getRealName();
        bo.setExpert(realNamepjebb0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据新增-踏勘专家j
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAdditionSurveyExpertJ(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        PlanToBindExpertsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增-踏勘专家j,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
            String anqheScript = "function mGetCurrentDateTime(){\n              var date = new Date();\n              var year = date.getFullYear();\n              var month = date.getMonth()+1;\n              var dates = date.getDate();\n              var hours = date.getHours();\n              var minutes = date.getMinutes();\n              var seconds = date.getSeconds();\n              month = month < 10 ? \'0\' + month : month;\n              dates = dates < 10 ? \'0\' + dates : dates;\n              hours = hours < 10 ? \'0\' + hours : hours;\n              minutes = minutes < 10 ? \'0\' + minutes : minutes;\n              seconds = seconds < 10 ? \'0\' + seconds : seconds;\n              return String(year + \'-\' + month + \'-\' + dates + \' \' + hours + \':\' + minutes + \':\' + seconds);\n          };\n\n\nreturn mGetCurrentDateTime();\n";
        List<BlocklyBindParamDto> psnsuBindparams = new ArrayList<>();
        Object ribto0Value = BlocklyUtils.exe(anqheScript, psnsuBindparams);
        Object ribto0 = ribto0Value;

        paramMap.put("creationTime", ribto0);
        Long tskID1 = bo.getTskID();
        paramMap.put("taskId", tskID1);
        Long tskID2 = bo.getTskID();
        paramMap.put("surveyTaskId", tskID2);
        Integer stage3 = bo.getStage();
        paramMap.put("surveyStep", stage3);
        Integer calculationExpertID4 = bo.getCalculationExpertID();
        paramMap.put("expertUserId", calculationExpertID4);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyExpertBO surveyExpertBO = BeanUtil.mapToBean(paramMap, SurveyExpertBO.class, null);
        String vo = surveyExpertService.insert(surveyExpertBO);
        bo.setDataAdditionSurveyExpertJ(vo);
        log.debug("流程名称：{},方法名称: 数据新增-踏勘专家j,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment_iqKP(paramsJsonContext, executeBO);
    }

    /**
    * 运算-专家id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationExpertID(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        PlanToBindExpertsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-专家id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_biz_flow_v2_process_output_param_U_99def2acaf094fb297a49eaff72fe9d7_u;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_process_output_param_U_99def2acaf094fb297a49eaff72fe9d7_u";
        String bindType0 = "Primarykey";
        String bindValue0 = bo.getSynchronousRefProc().getExpertApprovalInformation().getId_MjzA();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setCalculationExpertID(vo);
        log.debug("流程名称：{},方法名称: 运算-专家id,输出参数: {}",processName,JSON.toJSONString(vo));
        dataAdditionSurveyExpertJ(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-踏勘专家记录
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuerySurveyExpertRecords(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-踏勘专家记录==taskIdentifier：dataQuerySurveyExpertRecords==damMethod：dataQuery_KThG==");
        //调用数据查询
        PlanToBindExpertsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-踏勘专家记录,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveyExpert vo = surveyExpertAggregateService.dataQuery_KThG(paramsJsonContext,bo);
        bo.setDataQuerySurveyExpertRecords(vo);
        log.debug("流程名称：{},方法名称: 数据查询-踏勘专家记录,输出参数: {}",processName,JSON.toJSONString(vo));
        branch_yhIv(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch_yhIv(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branch_yhIvParamAssignment_iqKP(paramsJsonContext, executeBO)){
            paramAssignment_iqKP(paramsJsonContext, executeBO);
        }
        else {
            calculationExpertID(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branch_yhIvParamAssignment_iqKP(JSONObject paramsJsonContext, PlanToBindExpertsBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            PlanToBindExpertsBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Object dataQuerySurveyExpertRecords = bo.getDataQuerySurveyExpertRecords();
            boolean matchState = (((ObjectUtils.isNotEmpty(dataQuerySurveyExpertRecords))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

}