package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 根据bcxToken获取用户信息
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class ObtainUserInformationBasedOnBcxTokenService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据bcxToken获取用户信息";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyUserAggregateService surveyUserAggregateService;
    @Autowired
    private GatewayMatchService gatewayMatchService;    @Autowired
    private RedisUtil redisService;
    /**
    * 根据bcxToken获取用户信息接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(ObtainUserInformationBasedOnBcxTokenDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        ObtainUserInformationBasedOnBcxTokenBO bo = new ObtainUserInformationBasedOnBcxTokenBO();
        if (Objects.isNull(form)) {
            form = new ObtainUserInformationBasedOnBcxTokenDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询
        //用户是否存在
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"oToken","userInformation",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("oToken",boMap.get("oToken"));
                vo.put("userInformation",boMap.get("userInformation"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_cHlc==");
        //调用数据查询
        ObtainUserInformationBasedOnBcxTokenBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveyUser vo = surveyUserAggregateService.dataQuery_cHlc(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        doesTheUserExist(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        ObtainUserInformationBasedOnBcxTokenBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Object dataQuerykwelr0 = bo.getDataQuery();
        bo.setUserInformation(dataQuerykwelr0);
        String operationOtokennkpac1 = bo.getOperationOtoken();
        bo.setOToken(operationOtokennkpac1);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 用户是否存在
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void doesTheUserExist(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "用户是否存在";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(doesTheUserExistOperationOtoken(paramsJsonContext, executeBO)){
            operationOtoken(paramsJsonContext, executeBO);
        }
        else {
            endEvent(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean doesTheUserExistOperationOtoken(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            ObtainUserInformationBasedOnBcxTokenBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Object dataQuery = bo.getDataQuery();
            boolean matchState = (((ObjectUtils.isNotEmpty(dataQuery))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 设置Token
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void setToken(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========do setAuthToken method=======");
        String taskName = "设置Token";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        ObtainUserInformationBasedOnBcxTokenBO bo = executeBO;
        //获取token
        String token = bo.getOperationOtoken();
        if (ObjectUtils.isEmpty(token)) {
            throw new BusinessException("请传入token" + errorSuffix);
        }
        log.info("=====设置的token=====" + String.valueOf(token));
        boolean success = false;
        Long timeout = Long.valueOf(-1);
        //存储token
        redisService.set(String.valueOf(token), String.valueOf(token), timeout);
        success = true;
        UserSessionContext.setToken(String.valueOf(token));
        bo.setSetToken(success);

        operation(paramsJsonContext, executeBO);
    }

    /**
    * Redis新增
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void redisAdd(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========do set value to redis method=======");
        String taskName = "Redis新增";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        ObtainUserInformationBasedOnBcxTokenBO bo = executeBO;
        log.debug("流程名称：{},方法名称: Redis新增,输入参数: {}",processName,JSON.toJSONString(bo));
        boolean success = false;
        String userIDKey0 = bo.getOperation();
        String userIDValue0 = bo.getUserID();
        Long timeout0 = Long.valueOf(-1);
        if (ObjectUtils.isNotEmpty(userIDKey0)) {
            success = redisService.set(String.valueOf(userIDKey0), userIDValue0, timeout0);
        }
        bo.setRedisAdd(success);
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 运算
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operation(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        ObtainUserInformationBasedOnBcxTokenBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\n\'userId:\' + String(u_BasicCalculate_U_47404fd9f7ba40b084bfb10e1ff3f3d2_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_GenerateAuthToken_U_60a451047b684c719817bc1e352259c7_u";
        String bindType0 = "";
        Object bindValue0 = null;
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        String bindKey1 = "u_BasicCalculate_U_47404fd9f7ba40b084bfb10e1ff3f3d2_u";
        String bindType1 = "String";
        String bindValue1 = bo.getOperationOtoken();
        BlocklyBindParamDto paramDto1 = BlocklyBindParamDto.builder()
                .bindValue(bindValue1)
                .bindKey(bindKey1)
                .bindType(bindType1)
                .build();
        bindparams.add(paramDto1);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperation(vo);
        log.debug("流程名称：{},方法名称: 运算,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment_oxlp(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_oxlp(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        ObtainUserInformationBasedOnBcxTokenBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String idworvb0 = bo.getDataQuery().getId();
        bo.setUserID(idworvb0);
        redisAdd(paramsJsonContext, executeBO);
    }

    /**
    * 运算-otoken
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationOtoken(JSONObject paramsJsonContext, ObtainUserInformationBasedOnBcxTokenBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        ObtainUserInformationBasedOnBcxTokenBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-otoken,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\'k47eihre1ujd50lxzhknuw0k3zfvtr8q\';\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperationOtoken(vo);
        log.debug("流程名称：{},方法名称: 运算-otoken,输出参数: {}",processName,JSON.toJSONString(vo));
        setToken(paramsJsonContext, executeBO);
    }

}