package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import org.springframework.scheduling.annotation.Async;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 下一题
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class NxtQuestionService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "下一题";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyInfoAggregateService surveyInfoAggregateService;
    @Autowired
    private GatewayMatchService gatewayMatchService;
    /**
    * 下一题接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(NxtQuestionDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        NxtQuestionBO bo = new NxtQuestionBO();
        if (Objects.isNull(form)) {
            form = new NxtQuestionDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询-查之后的题目
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"nxtQuestionID",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("nxtQuestionID",boMap.get("nxtQuestionID"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, NxtQuestionBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQueryPostQueryQuestions(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, NxtQuestionBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询-查之后的题目
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryPostQueryQuestions(JSONObject paramsJsonContext, NxtQuestionBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-查之后的题目==taskIdentifier：dataQueryPostQueryQuestions==damMethod：dataQuery_VLaL==");
        //调用数据查询
        NxtQuestionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-查之后的题目,输入参数: {}",processName,JSON.toJSONString(bo));
        List<DataqueryVlalBO> vo = surveyInfoAggregateService.dataQuery_VLaL(paramsJsonContext,bo);
        bo.setDataQueryPostQueryQuestions(vo);
        log.debug("流程名称：{},方法名称: 数据查询-查之后的题目,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, NxtQuestionBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        NxtQuestionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String operationusfsa0 = bo.getOperation();
        bo.setNxtQuestionID(operationusfsa0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 代码块
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void codeBlk(JSONObject paramsJsonContext, NxtQuestionBO executeBO) throws BusinessException {
        log.info("========执行代码块方法=======");
        NxtQuestionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 代码块,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJson = new JSONObject();
        List dataQueryPostQueryQuestions0 = bo.getDataQueryPostQueryQuestions();
        paramsJson.put("idList", dataQueryPostQueryQuestions0);
        Integer vo = codeBlkCodeBlock(paramsJson);
        bo.setCodeBlk(vo);
        operation(paramsJsonContext, executeBO);
    }

    /**
     * 代码块执行代码块方法体
     * @param params
     * param idList 题目列表
     * @return 返回值
     */
    public Integer codeBlkCodeBlock(JSONObject params) throws BusinessException{
        //自定义代码块逻辑
        

JSONArray idList = params.getJSONArray("idList");
return idList.getJSONObject(0).getInteger("id");














    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, NxtQuestionBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchCodeBlk(paramsJsonContext, executeBO)){
            codeBlk(paramsJsonContext, executeBO);
        }
        else {
            endEvent(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchCodeBlk(JSONObject paramsJsonContext, NxtQuestionBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            NxtQuestionBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            List dataQueryPostQueryQuestions = bo.getDataQueryPostQueryQuestions();
            boolean matchState = (((ObjectUtils.isNotEmpty(dataQueryPostQueryQuestions))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 运算
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operation(JSONObject paramsJsonContext, NxtQuestionBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        NxtQuestionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nJSON.stringify(u_CodeBlock_U_fdb7ad58739f49cdb287183b732a1cba_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_CodeBlock_U_fdb7ad58739f49cdb287183b732a1cba_u";
        String bindType0 = "Integer";
        Integer bindValue0 = bo.getCodeBlk();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperation(vo);
        log.debug("流程名称：{},方法名称: 运算,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

}