package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.da.service.SurveyPlanService;
import com.wlos.app.bo.*;
import com.wlos.app.da.service.SurveyFeedbackService;
import com.wlos.app.da.service.SurveyQuestionnaireService;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 新增计划
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class NewPlanService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "新增计划";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanService surveyPlanService;
    @Autowired
    private SurveyFeedbackService surveyFeedbackService;    @Autowired
    private SurveyQuestionnaireService surveyQuestionnaireService;    @Autowired
    private QueryFixedProblemLstByStageService queryFixedProblemLstByStageService;    @Autowired
    private QueryTskDetailsService queryTskDetailsService;    @Autowired
    private AddFixedIssueTmpStgService addFixedIssueTmpStgService;
    /**
    * 新增计划接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(NewPlanDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        NewPlanBO bo = new NewPlanBO();
        if (Objects.isNull(form)) {
            form = new NewPlanDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算
        //新增查勘反馈
        //查勘反馈id转换
        //新增问卷
        //问卷id转换
        //同步引用流程-查询任务信息
        //同步引用流程固定问题查询
        //循环
        //新增计划
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        operation(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 新增计划
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void newPlan(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 新增计划,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Integer surveyFeedbackIDConversion0 = bo.getSurveyFeedbackIDConversion();
        paramMap.put("feedbackId", surveyFeedbackIDConversion0);
        Integer questionnaireIDConversion1 = bo.getQuestionnaireIDConversion();
        paramMap.put("questionnaireId", questionnaireIDConversion1);
        Long siteId2 = bo.getSiteId();
        paramMap.put("venueId", siteId2);
        Integer operation3 = bo.getOperation();
        paramMap.put("userId", operation3);
        Long tskId4 = bo.getTskId();
        paramMap.put("taskId", tskId4);
        Integer explorationFreq5 = bo.getExplorationFreq();
        paramMap.put("time", explorationFreq5);
        Object omwuk6 = "0";
        paramMap.put("taskStatus", omwuk6);
        Integer explorationPhase7 = bo.getExplorationPhase();
        paramMap.put("surveyStep", explorationPhase7);
        LocalDateTime startTime8 = bo.getStartTime();
        paramMap.put("beginTime", startTime8);
        LocalDateTime endTime9 = bo.getEndTime();
        paramMap.put("endTime", endTime9);
        Boolean isItAllDayLong10 = bo.getIsItAllDayLong();
        paramMap.put("allDay", isItAllDayLong10);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyPlanBO surveyPlanBO = BeanUtil.mapToBean(paramMap, SurveyPlanBO.class, null);
        String vo = surveyPlanService.insert(surveyPlanBO);
        bo.setNewPlan(vo);
        log.debug("流程名称：{},方法名称: 新增计划,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 新增查勘反馈
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void addSurveyFeedback(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 新增查勘反馈,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Integer explorationPhase0 = bo.getExplorationPhase();
        paramMap.put("surveyStep", explorationPhase0);
        Object bnxdk1 = "0";
        paramMap.put("taskStatus", bnxdk1);
        Long tskId2 = bo.getTskId();
        paramMap.put("taskId", tskId2);
        Integer operation3 = bo.getOperation();
        paramMap.put("userId", operation3);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyFeedbackBO surveyFeedbackBO = BeanUtil.mapToBean(paramMap, SurveyFeedbackBO.class, null);
        String vo = surveyFeedbackService.insert(surveyFeedbackBO);
        bo.setAddSurveyFeedback(vo);
        log.debug("流程名称：{},方法名称: 新增查勘反馈,输出参数: {}",processName,JSON.toJSONString(vo));
        surveyFeedbackIDConversion(paramsJsonContext, executeBO);
    }

    /**
    * 新增问卷
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void newQuestionnaireAdded(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 新增问卷,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Integer explorationPhase0 = bo.getExplorationPhase();
        paramMap.put("surveyStep", explorationPhase0);
        LocalDateTime startTime1 = bo.getStartTime();
        paramMap.put("beginTime", startTime1);
        LocalDateTime endTime2 = bo.getEndTime();
        paramMap.put("endTime", endTime2);
        Object dgrnp3 = "0";
        paramMap.put("taskStatus", dgrnp3);
        Long siteId4 = bo.getSiteId();
        paramMap.put("venueId", siteId4);
        Integer surveyFeedbackIDConversion5 = bo.getSurveyFeedbackIDConversion();
        paramMap.put("feedbackId", surveyFeedbackIDConversion5);
        Boolean booleanVNo6 = ElementConstants.booleanVNo;
        paramMap.put("correction", booleanVNo6);
        Boolean booleanVNo7 = ElementConstants.booleanVNo;
        paramMap.put("generate", booleanVNo7);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyQuestionnaireBO surveyQuestionnaireBO = BeanUtil.mapToBean(paramMap, SurveyQuestionnaireBO.class, null);
        String vo = surveyQuestionnaireService.insert(surveyQuestionnaireBO);
        bo.setNewQuestionnaireAdded(vo);
        log.debug("流程名称：{},方法名称: 新增问卷,输出参数: {}",processName,JSON.toJSONString(vo));
        questionnaireIDConversion(paramsJsonContext, executeBO);
    }

    /**
    * 查勘反馈id转换
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void surveyFeedbackIDConversion(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 查勘反馈id转换,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_AddData_U_b7a1b05a638b434a86bfba0d47a85672_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_AddData_U_b7a1b05a638b434a86bfba0d47a85672_u";
        String bindType0 = "String";
        String bindValue0 = bo.getAddSurveyFeedback();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setSurveyFeedbackIDConversion(vo);
        log.debug("流程名称：{},方法名称: 查勘反馈id转换,输出参数: {}",processName,JSON.toJSONString(vo));
        newQuestionnaireAdded(paramsJsonContext, executeBO);
    }

    /**
    * 问卷id转换
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void questionnaireIDConversion(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 问卷id转换,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_AddData_U_2a9d118a59cc4cbd9184e6b553cfe68a_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_AddData_U_2a9d118a59cc4cbd9184e6b553cfe68a_u";
        String bindType0 = "String";
        String bindValue0 = bo.getNewQuestionnaireAdded();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setQuestionnaireIDConversion(vo);
        log.debug("流程名称：{},方法名称: 问卷id转换,输出参数: {}",processName,JSON.toJSONString(vo));
        synchronizeRefProcQueryTskInformation(paramsJsonContext, executeBO);
    }

    /**
    * 同步引用流程固定问题查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronizeRefProcFixedProblemQuery(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程固定问题查询,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                String address_type0 = bo.getSynchronizeRefProcQueryTskInformation().getTskDetails().getAddress_type();
                jsonObjectNewParam.put("siteType", address_type0);
                String activity_type1 = bo.getSynchronizeRefProcQueryTskInformation().getTskDetails().getActivity_type();
                jsonObjectNewParam.put("activityType", activity_type1);
                Integer explorationPhase2 = bo.getExplorationPhase();
                jsonObjectNewParam.put("stageV123", explorationPhase2);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronizeRefProcFixedProblemQueryExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryFixedProblemLstByStageDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryFixedProblemLstByStageVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryFixedProblemLstByStageVO.class);
        bo.setSynchronizeRefProcFixedProblemQuery(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程固定问题查询,输出参数: {}",processName,JSON.toJSONString(vo));
        loop(paramsJsonContext, executeBO);
    }

    JSONObject synchronizeRefProcFixedProblemQueryExecSub(QueryFixedProblemLstByStageDTO form) throws BusinessException {
        return queryFixedProblemLstByStageService.processMainExecute(form);
    }

    /**
    * 同步引用流程-查询任务信息
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronizeRefProcQueryTskInformation(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程-查询任务信息,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                String personnelID0 = bo.getPersonnelID();
                jsonObjectNewParam.put("personnelID", personnelID0);
                Long tskId1 = bo.getTskId();
                jsonObjectNewParam.put("tskID", tskId1);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronizeRefProcQueryTskInformationExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryTskDetailsDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryTskDetailsVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryTskDetailsVO.class);
        bo.setSynchronizeRefProcQueryTskInformation(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程-查询任务信息,输出参数: {}",processName,JSON.toJSONString(vo));
        synchronizeRefProcFixedProblemQuery(paramsJsonContext, executeBO);
    }

    JSONObject synchronizeRefProcQueryTskInformationExecSub(QueryTskDetailsDTO form) throws BusinessException {
        return queryTskDetailsService.processMainExecute(form);
    }

    /**
    * 循环
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void loop(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行循环调用过程方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 循环,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONArray vo = new JSONArray();
        List loopArray = bo.getSynchronizeRefProcFixedProblemQuery().getDataLst();
        //获取需要循环的内容
        //执行循环
        if (CollectionUtils.isNotEmpty(loopArray)) {
            log.info("=============循环的数据有数据，准备执行循环子流程处理=================");
            for (int i = 0; i < loopArray.size(); i++) {
                //初始化下一个流程需要的data数据
                Map<String, Object> jsonObjectNewParam = new HashMap<>();
        JSONObject item = JSON.parseObject(JSON.toJSONString(loopArray.get(i)), JSONObject.class);
                Object sort0 =  item.get("sort");
                jsonObjectNewParam.put("sort", sort0);
                Object answerTip1 =  item.get("answerTip");
                jsonObjectNewParam.put("tips", answerTip1);
                Object question2 =  item.get("question");
                jsonObjectNewParam.put("subject", question2);
                Object id3 =  item.get("id");
                jsonObjectNewParam.put("problemID", id3);
                Integer questionnaireIDConversion4 = bo.getQuestionnaireIDConversion();
                jsonObjectNewParam.put("questionnaireID", questionnaireIDConversion4);
                log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
                JSONObject returnDataJson = addFixedIssueTmpStgService.processMainExecute(BeanUtil.mapToBean(jsonObjectNewParam, AddFixedIssueTmpStgDTO.class, null));
                //取返回结果
                if (null != returnDataJson) {
                    returnDataJson.remove("system_returnBelong");
                    returnDataJson.remove("system_flow_down_file_flag");
                }
                vo.add(returnDataJson);
            }
        } else {
            log.info("=============循环的数据为空，不执行循环子流程处理=================");
        }
        bo.setLoop(vo);
        newPlan(paramsJsonContext, executeBO);
    }

    /**
    * 运算
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operation(JSONObject paramsJsonContext, NewPlanBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        NewPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_biz_flow_v2_input_param_U_03d98bc3470843408bdec2d3d2742898_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_03d98bc3470843408bdec2d3d2742898_u";
        String bindType0 = "String";
        String bindValue0 = bo.getPersonnelID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperation(vo);
        log.debug("流程名称：{},方法名称: 运算,输出参数: {}",processName,JSON.toJSONString(vo));
        addSurveyFeedback(paramsJsonContext, executeBO);
    }

}