package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.VenueInformationService;
import com.wlos.app.bo.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.vo.*;
/**
* 修改场馆信息
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class ModifyVenueInformationService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "修改场馆信息";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private VenueInformationService venueInformationService;
    @Autowired
    private VenueInformationAggregateService venueInformationAggregateService;    @Autowired
    private GatewayMatchService gatewayMatchService;
    /**
    * 修改场馆信息接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(ModifyVenueInformationDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        ModifyVenueInformationBO bo = new ModifyVenueInformationBO();
        if (Objects.isNull(form)) {
            form = new ModifyVenueInformationDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"abnormalInformation",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("abnormalInformation",boMap.get("abnormalInformation"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, ModifyVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, ModifyVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据修改
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModification(JSONObject paramsJsonContext, ModifyVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        ModifyVenueInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Object uqkdi0 = null;
                paramMap.put("modificationTime", uqkdi0);
                String venueName1 = bo.getVenueName();
                paramMap.put("venueName", venueName1);
                String provinceCode2 = bo.getProvinceCode();
                paramMap.put("province", provinceCode2);
                String cityCode3 = bo.getCityCode();
                paramMap.put("city", cityCode3);
                String contactNum4 = bo.getContactNum();
                paramMap.put("phone", contactNum4);
                String venueAddr5 = bo.getVenueAddr();
                paramMap.put("venueAddress", venueAddr5);
                String venueType6 = bo.getVenueType();
                paramMap.put("venueType", venueType6);
                Object fcgla7 = "0";
                paramMap.put("nature", fcgla7);
                String venueIntroduction8 = bo.getVenueIntroduction();
                paramMap.put("venueIntroduction", venueIntroduction8);
                String regionalLocation9 = bo.getRegionalLocation();
                paramMap.put("regionalLocation", regionalLocation9);
                String businessLicenseAddr10 = bo.getBusinessLicenseAddr();
                paramMap.put("businessLicenseAddr", businessLicenseAddr10);
                String unifiedCreditCode11 = bo.getUnifiedCreditCode();
                paramMap.put("unifiedCreditCode", unifiedCreditCode11);

        JSONObject whereParamMap = new JSONObject();
                String venueID12 = bo.getVenueID();
                whereParamMap.put("venueInformationId", venueID12);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        VenueInformationBO venueInformationBO = BeanUtil.mapToBean(paramMap, VenueInformationBO.class, null);
        ModifyvenueinformationdataModificationWhereBO modifyvenueinformationdataModificationWhereBO = BeanUtil.mapToBean(whereParamMap, ModifyvenueinformationdataModificationWhereBO.class, null);
        Integer vo = venueInformationService.update(venueInformationBO, modifyvenueinformationdataModificationWhereBO);
        bo.setDataModification(vo);
        log.debug("流程名称：{},方法名称: 数据修改,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, ModifyVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_Hwic==");
        //调用数据查询
        ModifyVenueInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        VenueInformation vo = venueInformationAggregateService.dataQuery_Hwic(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, ModifyVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchDataModification(paramsJsonContext, executeBO)){
            dataModification(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchDataModification(JSONObject paramsJsonContext, ModifyVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            ModifyVenueInformationBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Object dataQuery = bo.getDataQuery();
            boolean matchState = (((ObjectUtils.isNotEmpty(dataQuery))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, ModifyVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        ModifyVenueInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String bslty0 = "不是创建人无修改权限";
        bo.setAbnormalInformation(bslty0);
        endEvent(paramsJsonContext, executeBO);
    }

}