package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.SurveyTaskService;
import com.wlos.app.bo.*;
import org.springframework.scheduling.annotation.Async;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 修改任务状态
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class ModifyTskStsService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "修改任务状态";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyTaskService surveyTaskService;

    /**
    * 修改任务状态接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(ModifyTskStsDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        ModifyTskStsBO bo = new ModifyTskStsBO();
        if (Objects.isNull(form)) {
            form = new ModifyTskStsDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算-用户id
        //代码块获取日期
        //数据修改
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, ModifyTskStsBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        calculationUserID(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, ModifyTskStsBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据修改
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModification(JSONObject paramsJsonContext, ModifyTskStsBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        ModifyTskStsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                String tskSts0 = bo.getTskSts();
                paramMap.put("surveyTaskStatus", tskSts0);
                LocalDateTime codeBlkAcquisitionDate1 = bo.getCodeBlkAcquisitionDate();
                paramMap.put("modificationTime", codeBlkAcquisitionDate1);

        JSONObject whereParamMap = new JSONObject();
                String tskID2 = bo.getTskID();
                whereParamMap.put("surveyTaskId", tskID2);
                Integer calculationUserID3 = bo.getCalculationUserID();
                whereParamMap.put("surveyTaskUserId", calculationUserID3);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyTaskBO surveyTaskBO = BeanUtil.mapToBean(paramMap, SurveyTaskBO.class, null);
        ModifytskstsdataModificationWhereBO modifytskstsdataModificationWhereBO = BeanUtil.mapToBean(whereParamMap, ModifytskstsdataModificationWhereBO.class, null);
        Integer vo = surveyTaskService.update(surveyTaskBO, modifytskstsdataModificationWhereBO);
        bo.setDataModification(vo);
        log.debug("流程名称：{},方法名称: 数据修改,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 代码块获取日期
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void codeBlkAcquisitionDate(JSONObject paramsJsonContext, ModifyTskStsBO executeBO) throws BusinessException {
        log.info("========执行代码块方法=======");
        ModifyTskStsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 代码块获取日期,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJson = new JSONObject();
        LocalDateTime vo = codeBlkAcquisitionDateCodeBlock(paramsJson);
        bo.setCodeBlkAcquisitionDate(vo);
        dataModification(paramsJsonContext, executeBO);
    }

    /**
     * 代码块获取日期执行代码块方法体
     * @param params
     * @return 返回值
     */
    public LocalDateTime codeBlkAcquisitionDateCodeBlock(JSONObject params) throws BusinessException{
        //自定义代码块逻辑
        Date currentDate = new Date();
LocalDateTime localDateTime = LocalDateTime.ofInstant(currentDate.toInstant(), ZoneId.systemDefault());
return localDateTime;









    }

    /**
    * 运算-用户id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationUserID(JSONObject paramsJsonContext, ModifyTskStsBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        ModifyTskStsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-用户id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "1;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setCalculationUserID(vo);
        log.debug("流程名称：{},方法名称: 运算-用户id,输出参数: {}",processName,JSON.toJSONString(vo));
        codeBlkAcquisitionDate(paramsJsonContext, executeBO);
    }

}