package com.wlos.app.bl.impl;

import cn.hutool.core.util.RandomUtil;
import com.wlos.app.bl.IdempotentService;
import com.wlos.app.utils.RedisUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @ClassName IdempotentServiceImpl
 * @Author Tazerotoo
 * @Date 2023/11/20 17:42
 * 幂等
 */
@Slf4j
@Service
public class IdempotentServiceImpl implements IdempotentService {

    @Autowired
    private RedisUtil redisUtil;

    @Override
    public String getIdempotentToken() {
        final int length = 32;
        final Long time = 7200L;
        String idempotentToken = RandomUtil.randomString(length);
        redisUtil.set(idempotentToken, idempotentToken, time);
        return idempotentToken;
    }
}
