package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import cn.hutool.http.HttpRequest;
import org.apache.http.entity.ContentType;
/**
* 生成踏勘报告
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class GenSurveyReportService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "生成踏勘报告";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private QueryAllQuestionListsBasedOnQuestionnaireIDService queryAllQuestionListsBasedOnQuestionnaireIDService;

    /**
    * 生成踏勘报告接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(GenSurveyReportDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        GenSurveyReportBO bo = new GenSurveyReportBO();
        if (Objects.isNull(form)) {
            form = new GenSurveyReportDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //同步引用流程
        //生成JSON
        //HTTP请求
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"fileAddr",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("fileAddr",boMap.get("fileAddr"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, GenSurveyReportBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        synchronousRefProc(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, GenSurveyReportBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * HTTP请求
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void hTTPReq(JSONObject paramsJsonContext, GenSurveyReportBO executeBO) throws BusinessException {
        log.info("========执行doHttp方法=======");
        String taskName = "HTTP请求";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        GenSurveyReportBO bo = executeBO;
        String methodUrl = "https://takan.test.pss360.cn/wechat/survey/createSurveyReportTest";
        if (ObjectUtils.isEmpty(methodUrl)) {
            throw new BusinessException("未设置请求地址" + errorSuffix);
        }
        //请求url
        String url = String.valueOf(methodUrl);
        


        int timeout=60000;
        //请求方式
        String requestMethod = "POST";
        //contentType
        String contentType = ContentType.APPLICATION_JSON.getMimeType();
        log.info("====requestMethod====" + requestMethod);
				log.info("====methodUrl====" + url);
        //执行http请求

        String rawContent = bo.getGenJSON();

        String analysisContent = HttpRequest
                .post(url)
                .body(String.valueOf(rawContent), contentType)
                .timeout(timeout)
                .execute()
                .body();
        log.info("=======请求返回数据====" + analysisContent);
        //处理返回值
        bo.setHTTPReq(analysisContent);
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 同步引用流程
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronousRefProc(JSONObject paramsJsonContext, GenSurveyReportBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        GenSurveyReportBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                String questionnaireID0 = bo.getQuestionnaireID();
                jsonObjectNewParam.put("questionnaireID", questionnaireID0);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronousRefProcExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryAllQuestionListsBasedOnQuestionnaireIDDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryAllQuestionListsBasedOnQuestionnaireIDVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryAllQuestionListsBasedOnQuestionnaireIDVO.class);
        bo.setSynchronousRefProc(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程,输出参数: {}",processName,JSON.toJSONString(vo));
        genJSON(paramsJsonContext, executeBO);
    }

    JSONObject synchronousRefProcExecSub(QueryAllQuestionListsBasedOnQuestionnaireIDDTO form) throws BusinessException {
        return queryAllQuestionListsBasedOnQuestionnaireIDService.processMainExecute(form);
    }

    /**
    * 生成JSON
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void genJSON(JSONObject paramsJsonContext, GenSurveyReportBO executeBO) throws BusinessException {
        log.info("========执行生成json方法=======");
        GenSurveyReportBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 生成JSON,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject bindings = new JSONObject();
        String oid4p2o = bo.getQuestionnaireID();
        bindings.put("oid",oid4p2o);
        String taskNameb8iy = bo.getTaskName();
        bindings.put("taskName",taskNameb8iy);
        String venueNamevw9c = bo.getVenueName();
        bindings.put("venueName",venueNamevw9c);
        String surveyStep5ycm = bo.getSurveyStep();
        bindings.put("surveyStep",surveyStep5ycm);
        List answersb7ks = bo.getSynchronousRefProc().getLstOfAllQuestions();
        bindings.put("answers",answersb7ks);
       String vo = JSON.toJSONString(bindings);
        log.debug("流程名称：{},方法名称: 生成JSON,输出参数: {}",processName,JSON.toJSONString(vo));
        bo.setGenJSON(vo);
        hTTPReq(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, GenSurveyReportBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        GenSurveyReportBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String hTTPReqsznkv0 = bo.getHTTPReq();
        bo.setFileAddr(hTTPReqsznkv0);
        endEvent(paramsJsonContext, executeBO);
    }

}