package com.wlos.app.bl.impl;

import com.wlos.app.bl.ParseService;
import org.springframework.stereotype.Service;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.listener.PageReadListener;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;

@Service
public class ExcelParseService implements ParseService {

    @Override
    public boolean support(String fileType) {
        return "xlsx".equals(fileType) || "xls".equals(fileType);
    }

    @Override
    public List<Object> parse(Class<Object> clazz, byte[] file) throws Exception {
        List<Object> list = new ArrayList<>();
        EasyExcelFactory.read(new ByteArrayInputStream(file), clazz, new PageReadListener<>(list::addAll)).sheet().doRead();
        return list;
    }

    @Override
    public byte[] importTemplate(Class<Object> clazz) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EasyExcelFactory.write(outputStream, clazz).sheet().doWrite(new ArrayList<>());
        return outputStream.toByteArray();
    }

    @Override
    public byte[] exportModel(Class<Object> clazz, List<Object> list, List<String> headers, UnaryOperator<Object> fun) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        MyList<Object> myList = new MyList<>(fun);
        myList.addAll(list);
        EasyExcelFactory.write(outputStream, clazz).includeColumnFieldNames(headers).sheet().doWrite(myList);
        return outputStream.toByteArray();
    }

    static class MyList<E> extends ArrayList<E> {

        private final UnaryOperator<Object> nextCallback;

        MyList(UnaryOperator<Object> nextCallback) {
            this.nextCallback = nextCallback;
        }

        @Override
        public Iterator<E> iterator() {
            return new MyItr<>(super.iterator(), nextCallback);
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    static class MyItr<E> implements Iterator<E>{
        private final Iterator<E> iterator;
        private final UnaryOperator<Object> nextCallback;

        public MyItr(Iterator<E> iterator, UnaryOperator<Object> nextCallback) {
            this.iterator = iterator;
            this.nextCallback = nextCallback;
        }

        @Override
        public boolean hasNext() {
            return iterator.hasNext();
        }

        @Override
        public E next() {
            nextCallback.apply(null);
            return iterator.next();
        }
    }
}