package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.SurveyInfoService;
import com.wlos.app.da.service.SurveyReformService;
import com.wlos.app.da.service.SurveyProjectService;
/**
* 根据问卷问题id删除对应记录
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据问卷问题id删除对应记录";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyInfoService surveyInfoService;
    @Autowired
    private SurveyReformService surveyReformService;    @Autowired
    private SurveyProjectService surveyProjectService;
    /**
    * 根据问卷问题id删除对应记录接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO bo = new DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO();
        if (Objects.isNull(form)) {
            form = new DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据删除-整改表
        //数据删除-问卷题目
        //问题回答表记录删除
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataDeletionRectificationTbl(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 问题回答表记录删除
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void delRecordOfQuestionAnswerTbl(JSONObject paramsJsonContext, DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO executeBO) throws BusinessException {
        log.info("========执行数据删除方法=======");
        DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 问题回答表记录删除,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        String questionnaireQuestionID0 = bo.getQuestionnaireQuestionID();
        paramMap.put("surveyInfoId", questionnaireQuestionID0);
        //调用数据删除
        log.info("============dm params===" + paramMap.toJSONString());
        //获取返回数据存在的key值
        DelcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO = BeanUtil.mapToBean(paramMap, DelcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO.class, null);
        Integer vo = surveyInfoService.delete(delcorrespondingrecordsbasedonquestionnairequestioniddelRecordOfQuestionAnswerTblWhereBO);
        bo.setDelRecordOfQuestionAnswerTbl(vo);
        log.debug("流程名称：{},方法名称: 问题回答表记录删除,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据删除-整改表
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataDeletionRectificationTbl(JSONObject paramsJsonContext, DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO executeBO) throws BusinessException {
        log.info("========执行数据删除方法=======");
        DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据删除-整改表,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        String rectificationID0 = bo.getRectificationID();
        paramMap.put("surveyReformId", rectificationID0);
        //调用数据删除
        log.info("============dm params===" + paramMap.toJSONString());
        //获取返回数据存在的key值
        DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBO = BeanUtil.mapToBean(paramMap, DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBO.class, null);
        Integer vo = surveyReformService.delete(delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBO);
        bo.setDataDeletionRectificationTbl(vo);
        log.debug("流程名称：{},方法名称: 数据删除-整改表,输出参数: {}",processName,JSON.toJSONString(vo));
        dataDeletionQuestionnaireQuestions(paramsJsonContext, executeBO);
    }

    /**
    * 数据删除-问卷题目
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataDeletionQuestionnaireQuestions(JSONObject paramsJsonContext, DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO executeBO) throws BusinessException {
        log.info("========执行数据删除方法=======");
        DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据删除-问卷题目,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
            String atngdScript = "\n\n\nNumber(u_biz_flow_v2_input_param_U_43dd48efe44b4188bdb27ba2d322414f_u);\n";
        List<BlocklyBindParamDto> aypvlBindparams = new ArrayList<>();
        String bindKeyrcflm0 = "u_biz_flow_v2_input_param_U_43dd48efe44b4188bdb27ba2d322414f_u";
        String bindTypevmcvk0 = "String";
        String bindValueyauyz0 = bo.getQuestionnaireQuestionID();
        BlocklyBindParamDto paramDtoVariableNamedfojp0 = BlocklyBindParamDto.builder()
            .bindValue(bindValueyauyz0)
            .bindKey(bindKeyrcflm0)
            .bindType(bindTypevmcvk0)
            .build();
        aypvlBindparams.add(paramDtoVariableNamedfojp0);
        Object ovlio0Value = BlocklyUtils.exe(atngdScript, aypvlBindparams);
        Object ovlio0 = ovlio0Value;

        paramMap.put("surveyProjectSurvey_info_id", ovlio0);
        //调用数据删除
        log.info("============dm params===" + paramMap.toJSONString());
        //获取返回数据存在的key值
        DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBO = BeanUtil.mapToBean(paramMap, DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBO.class, null);
        Integer vo = surveyProjectService.delete(delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBO);
        bo.setDataDeletionQuestionnaireQuestions(vo);
        log.debug("流程名称：{},方法名称: 数据删除-问卷题目,输出参数: {}",processName,JSON.toJSONString(vo));
        delRecordOfQuestionAnswerTbl(paramsJsonContext, executeBO);
    }

}