package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 踏勘是否签到
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class ChkIfThereIsASignInDuringTheInspectionService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "踏勘是否签到";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveySignAggregateService surveySignAggregateService;
    @Autowired
    private GatewayMatchService gatewayMatchService;
    /**
    * 踏勘是否签到接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(ChkIfThereIsASignInDuringTheInspectionDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        ChkIfThereIsASignInDuringTheInspectionBO bo = new ChkIfThereIsASignInDuringTheInspectionBO();
        if (Objects.isNull(form)) {
            form = new ChkIfThereIsASignInDuringTheInspectionDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"chkInOrNot",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("chkInOrNot",boMap.get("chkInOrNot"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, ChkIfThereIsASignInDuringTheInspectionBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, ChkIfThereIsASignInDuringTheInspectionBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, ChkIfThereIsASignInDuringTheInspectionBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_gUpr==");
        //调用数据查询
        ChkIfThereIsASignInDuringTheInspectionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveySign> vo = surveySignAggregateService.dataQuery_gUpr(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, ChkIfThereIsASignInDuringTheInspectionBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchParamAssignment_tdSR(paramsJsonContext, executeBO)){
            paramAssignment_tdSR(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchParamAssignment_tdSR(JSONObject paramsJsonContext, ChkIfThereIsASignInDuringTheInspectionBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            ChkIfThereIsASignInDuringTheInspectionBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            List dataQuery = bo.getDataQuery();
            boolean matchState = (((ObjectUtils.isNotEmpty(dataQuery))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, ChkIfThereIsASignInDuringTheInspectionBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        ChkIfThereIsASignInDuringTheInspectionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Integer crzvj0 = 0;
        bo.setChkInOrNot(crzvj0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_tdSR(JSONObject paramsJsonContext, ChkIfThereIsASignInDuringTheInspectionBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        ChkIfThereIsASignInDuringTheInspectionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Integer mpppp0 = 1;
        bo.setChkInOrNot(mpppp0);
        endEvent(paramsJsonContext, executeBO);
    }

}