
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class BaseRegionAggregateServiceImpl implements BaseRegionAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private BaseRegionService baseRegionService;


    /**
    * 聚合查询：根据上级编码和级别编号查询市级列表-数据查询
    * @return
    */
    @Override
    public List<BaseRegion> dataQuery_YQXF(JSONObject paramsJsonContext,QueryCityLevelLstBasedOnSuperiorCodeAndLevelNumBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String parentId0 = bo.getParentId();
        queryParams.put("baseRegionParentId", parentId0);
        String level1 = bo.getLevel();
        queryParams.put("baseRegionLevel", level1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_YQXFWhereBO dataQuery_YQXFWhereBO = BeanUtil.toBean(queryParams, DataQuery_YQXFWhereBO.class);
        List<BaseRegion> queryResult = baseRegionService.list(dataQuery_YQXFWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：查询省级列表-数据查询
    * @return
    */
    @Override
    public List<BaseRegion> dataQuery_EUQO(JSONObject paramsJsonContext,QueryProvincialLstBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Object wlugb0 = "1";
        queryParams.put("baseRegionLevel", wlugb0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_EUQOWhereBO dataQuery_EUQOWhereBO = BeanUtil.toBean(queryParams, DataQuery_EUQOWhereBO.class);
        List<BaseRegion> queryResult = baseRegionService.list(dataQuery_EUQOWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据id获取区域信息-数据查询-区域
    * @return
    */
    @Override
    public BaseRegion dataQuery_gdkB(JSONObject paramsJsonContext,ObtainRegionalInformationBasedOnIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String rgnID0 = bo.getRgnID();
        queryParams.put("baseRegionId", rgnID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_gdkBWhereBO dataQuery_gdkBWhereBO = BeanUtil.toBean(queryParams, DataQuery_gdkBWhereBO.class);
        BaseRegion queryResult = baseRegionService.selectOne(dataQuery_gdkBWhereBO);
        return queryResult;
    }


}