
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class BaseFixedIssueAggregateServiceImpl implements BaseFixedIssueAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private BaseFixedIssueService baseFixedIssueService;


    /**
    * 聚合查询：暂存固定和开放问题-数据查询固定问题
    * @return
    */
    @Override
    public List<BaseFixedIssue> dataQuery_ltrJ(JSONObject paramsJsonContext,TmpStgOfFixedAndOpenIssuesBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
            String szxieScript = "\n\n\nu_biz_flow_v2_input_param_U_c62eba9821924f68ad590e357483a12b_u;\n";
        List<BlocklyBindParamDto> vdwyaBindparams = new ArrayList<>();
        String bindKeytvrvn0 = "u_biz_flow_v2_input_param_U_c62eba9821924f68ad590e357483a12b_u";
        String bindTypewbigy0 = "List";
        List bindValuenfuvm0 = bo.getProblemIDLst();
        BlocklyBindParamDto paramDtoVariableNamemqdho0 = BlocklyBindParamDto.builder()
            .bindValue(bindValuenfuvm0)
            .bindKey(bindKeytvrvn0)
            .bindType(bindTypewbigy0)
            .build();
        vdwyaBindparams.add(paramDtoVariableNamemqdho0);
        Object lygoi0Value = BlocklyUtils.exe(szxieScript, vdwyaBindparams);
        Object lygoi0 = lygoi0Value;

        queryParams.put("baseFixedIssueId", lygoi0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_ltrJWhereBO dataQuery_ltrJWhereBO = BeanUtil.toBean(queryParams, DataQuery_ltrJWhereBO.class);
        List<BaseFixedIssue> queryResult = baseFixedIssueService.list(dataQuery_ltrJWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据阶段查询固定问题列表-通用问题查询
    * @return
    */
    @Override
    public List<BaseFixedIssue> dataQuery_lINF(JSONObject paramsJsonContext,QueryFixedProblemLstByStageBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Integer stageV1230 = bo.getStageV123();
        queryParams.put("baseFixedIssueSurveyStep", stageV1230);
        Object dfqww1 = "1";
        queryParams.put("baseFixedIssueGm", dfqww1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_lINFWhereBO dataQuery_lINFWhereBO = BeanUtil.toBean(queryParams, DataQuery_lINFWhereBO.class);
        List<BaseFixedIssue> queryResult = baseFixedIssueService.list(dataQuery_lINFWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据阶段查询固定问题列表-根据场地及活动类型查询
    * @return
    */
    @Override
    public List<BaseFixedIssue> dataQuery_FuxV(JSONObject paramsJsonContext,QueryFixedProblemLstByStageBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String activityType0 = bo.getActivityType();
        queryParams.put("baseFixedIssueActivityType", activityType0);
        String addrType1 = bo.getAddrType();
        queryParams.put("baseFixedIssueAddressType", addrType1);
        Integer stageV1232 = bo.getStageV123();
        queryParams.put("baseFixedIssueSurveyStep", stageV1232);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_FuxVWhereBO dataQuery_FuxVWhereBO = BeanUtil.toBean(queryParams, DataQuery_FuxVWhereBO.class);
        List<BaseFixedIssue> queryResult = baseFixedIssueService.list(dataQuery_FuxVWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据阶段查询问题数量-数据查询
    * @return
    */
    @Override
    public Page<BaseFixedIssue> dataQuery_dvJR(JSONObject paramsJsonContext,QueryTheNumOfIssuesByStageBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Object haahy0 = "10";
        queryParams.put("size", haahy0);
        Object auevp1 = "1";
        queryParams.put("current", auevp1);
        String activityType2 = bo.getActivityType();
        queryParams.put("baseFixedIssueActivityType", activityType2);
        String addrType3 = bo.getAddrType();
        queryParams.put("baseFixedIssueAddressType", addrType3);
        queryParams.put("current", Optional.ofNullable(queryParams.get("current")).orElse(1));
        queryParams.put("size", Optional.ofNullable(queryParams.get("size")).orElse(10));
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_dvJRWhereBO dataQuery_dvJRWhereBO = BeanUtil.toBean(queryParams, DataQuery_dvJRWhereBO.class);
        Page<BaseFixedIssue> queryResult = baseFixedIssueService.page(dataQuery_dvJRWhereBO);
        return queryResult;
    }


}