package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.da.service.SurveyInfoService;
import com.wlos.app.bo.*;
import com.wlos.app.da.service.SurveyProjectService;
import com.wlos.app.da.service.SurveyReformService;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import com.wlos.app.bo.where.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.vo.*;
/**
* 新增问卷补充问题记录
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class AddSupplementaryQuestionnaireQuestionRecordsService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "新增问卷补充问题记录";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyInfoService surveyInfoService;
    @Autowired
    private SurveyProjectService surveyProjectService;    @Autowired
    private SurveyReformService surveyReformService;    @Autowired
    private SurveyQuestionnaireAggregateService surveyQuestionnaireAggregateService;
    /**
    * 新增问卷补充问题记录接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(AddSupplementaryQuestionnaireQuestionRecordsDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = new AddSupplementaryQuestionnaireQuestionRecordsBO();
        if (Objects.isNull(form)) {
            form = new AddSupplementaryQuestionnaireQuestionRecordsDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算-转问卷id
        //数据查询-获取问卷信息
        //运算-空字符
        //数据新增-整改信息
        //运算-整改信息id
        //数据新增-具体问题回答
        //运算-具体回答id
        //数据新增-题目
        //运算-题目id
        //运算-转整数题目id
        //数据修改
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        calcAndConvQuestionnaireID(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据新增-具体问题回答
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAdditionSpecificQuestionAnswers(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增-具体问题回答,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Integer extremelyShortIntegerNo0 = ElementConstants.extremelyShortIntegerNo;
        paramMap.put("nextSurvey", extremelyShortIntegerNo0);
        Integer theExtremelyShortIntegerIs1 = ElementConstants.theExtremelyShortIntegerIs;
        paramMap.put("replied", theExtremelyShortIntegerIs1);
        Long questionnaireID2 = bo.getQuestionnaireID();
        paramMap.put("questionnaireId", questionnaireID2);
        Integer calculationRectificationInformationID3 = bo.getCalculationRectificationInformationID();
        paramMap.put("reformId", calculationRectificationInformationID3);
        String answerCont4 = bo.getAnswerCont();
        paramMap.put("answer", answerCont4);
        String answerTheAttachmentCol5 = bo.getAnswerTheAttachmentCol();
        paramMap.put("urls", answerTheAttachmentCol5);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyInfoBO surveyInfoBO = BeanUtil.mapToBean(paramMap, SurveyInfoBO.class, null);
        String vo = surveyInfoService.insert(surveyInfoBO);
        bo.setDataAdditionSpecificQuestionAnswers(vo);
        log.debug("流程名称：{},方法名称: 数据新增-具体问题回答,输出参数: {}",processName,JSON.toJSONString(vo));
        operationSpecificAnswerId(paramsJsonContext, executeBO);
    }

    /**
    * 数据新增-题目
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAdditionQuestion(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增-题目,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        String problem0 = bo.getProblem();
        paramMap.put("question", problem0);
        String rfbtd1 = "3";
        paramMap.put("questionType", rfbtd1);
        String surveyStep2 = bo.getDataQueryObtainQuestionnaireInformation().getSurveyStep();
        paramMap.put("surveyStep", surveyStep2);
        Integer operationSpecificAnswerId3 = bo.getOperationSpecificAnswerId();
        paramMap.put("survey_info_id", operationSpecificAnswerId3);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyProjectBO surveyProjectBO = BeanUtil.mapToBean(paramMap, SurveyProjectBO.class, null);
        String vo = surveyProjectService.insert(surveyProjectBO);
        bo.setDataAdditionQuestion(vo);
        log.debug("流程名称：{},方法名称: 数据新增-题目,输出参数: {}",processName,JSON.toJSONString(vo));
        operationQuestionID(paramsJsonContext, executeBO);
    }

    /**
    * 数据新增-整改信息
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAdditionRectificationInformation(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增-整改信息,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        String arithmeticEmptyChar0 = bo.getArithmeticEmptyChar();
        paramMap.put("result", arithmeticEmptyChar0);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyReformBO surveyReformBO = BeanUtil.mapToBean(paramMap, SurveyReformBO.class, null);
        String vo = surveyReformService.insert(surveyReformBO);
        bo.setDataAdditionRectificationInformation(vo);
        log.debug("流程名称：{},方法名称: 数据新增-整改信息,输出参数: {}",processName,JSON.toJSONString(vo));
        calculationRectificationInformationID(paramsJsonContext, executeBO);
    }

    /**
    * 运算-整改信息id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationRectificationInformationID(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-整改信息id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_AddData_U_afb90bf42b92476ca9d15d2db3737461_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_AddData_U_afb90bf42b92476ca9d15d2db3737461_u";
        String bindType0 = "String";
        String bindValue0 = bo.getDataAdditionRectificationInformation();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setCalculationRectificationInformationID(vo);
        log.debug("流程名称：{},方法名称: 运算-整改信息id,输出参数: {}",processName,JSON.toJSONString(vo));
        dataAdditionSpecificQuestionAnswers(paramsJsonContext, executeBO);
    }

    /**
    * 运算-具体回答id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationSpecificAnswerId(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-具体回答id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_AddData_U_c4d2642ee0e44f4db9e8696a312253c3_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_AddData_U_c4d2642ee0e44f4db9e8696a312253c3_u";
        String bindType0 = "String";
        String bindValue0 = bo.getDataAdditionSpecificQuestionAnswers();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperationSpecificAnswerId(vo);
        log.debug("流程名称：{},方法名称: 运算-具体回答id,输出参数: {}",processName,JSON.toJSONString(vo));
        dataAdditionQuestion(paramsJsonContext, executeBO);
    }

    /**
    * 数据修改
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModification(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                String operationQuestionID0 = bo.getOperationQuestionID();
                paramMap.put("aid", operationQuestionID0);
                Integer operationConvToIntegerQuestionID1 = bo.getOperationConvToIntegerQuestionID();
                paramMap.put("sort", operationConvToIntegerQuestionID1);

        JSONObject whereParamMap = new JSONObject();
                String operationQuestionID2 = bo.getOperationQuestionID();
                whereParamMap.put("surveyProjectId", operationQuestionID2);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyProjectBO surveyProjectBO = BeanUtil.mapToBean(paramMap, SurveyProjectBO.class, null);
        AddsupplementaryquestionnairequestionrecordsdataModificationWhereBO addsupplementaryquestionnairequestionrecordsdataModificationWhereBO = BeanUtil.mapToBean(whereParamMap, AddsupplementaryquestionnairequestionrecordsdataModificationWhereBO.class, null);
        Integer vo = surveyProjectService.update(surveyProjectBO, addsupplementaryquestionnairequestionrecordsdataModificationWhereBO);
        bo.setDataModification(vo);
        log.debug("流程名称：{},方法名称: 数据修改,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 运算-题目id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationQuestionID(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-题目id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_AddData_U_424e808a6f5a4e508bb05bfb27ff76f7_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_AddData_U_424e808a6f5a4e508bb05bfb27ff76f7_u";
        String bindType0 = "String";
        String bindValue0 = bo.getDataAdditionQuestion();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperationQuestionID(vo);
        log.debug("流程名称：{},方法名称: 运算-题目id,输出参数: {}",processName,JSON.toJSONString(vo));
        operationConvToIntegerQuestionID(paramsJsonContext, executeBO);
    }

    /**
    * 运算-转整数题目id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationConvToIntegerQuestionID(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-转整数题目id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_BasicCalculate_U_23c2a5e630874d39bb821b8026c0b4f5_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_BasicCalculate_U_23c2a5e630874d39bb821b8026c0b4f5_u";
        String bindType0 = "String";
        String bindValue0 = bo.getOperationQuestionID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperationConvToIntegerQuestionID(vo);
        log.debug("流程名称：{},方法名称: 运算-转整数题目id,输出参数: {}",processName,JSON.toJSONString(vo));
        dataModification(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-获取问卷信息
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryObtainQuestionnaireInformation(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-获取问卷信息==taskIdentifier：dataQueryObtainQuestionnaireInformation==damMethod：dataQuery_yeFL==");
        //调用数据查询
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-获取问卷信息,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveyQuestionnaire vo = surveyQuestionnaireAggregateService.dataQuery_yeFL(paramsJsonContext,bo);
        bo.setDataQueryObtainQuestionnaireInformation(vo);
        log.debug("流程名称：{},方法名称: 数据查询-获取问卷信息,输出参数: {}",processName,JSON.toJSONString(vo));
        arithmeticEmptyChar(paramsJsonContext, executeBO);
    }

    /**
    * 运算-转问卷id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calcAndConvQuestionnaireID(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-转问卷id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nString(u_biz_flow_v2_input_param_U_df19ad4c1c1c46c08b4957d3f6babe98_u) + \'\';\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_df19ad4c1c1c46c08b4957d3f6babe98_u";
        String bindType0 = "BigInteger";
        Long bindValue0 = bo.getQuestionnaireID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setCalcAndConvQuestionnaireID(vo);
        log.debug("流程名称：{},方法名称: 运算-转问卷id,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQueryObtainQuestionnaireInformation(paramsJsonContext, executeBO);
    }

    /**
    * 运算-空字符
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void arithmeticEmptyChar(JSONObject paramsJsonContext, AddSupplementaryQuestionnaireQuestionRecordsBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddSupplementaryQuestionnaireQuestionRecordsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-空字符,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\'\';\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setArithmeticEmptyChar(vo);
        log.debug("流程名称：{},方法名称: 运算-空字符,输出参数: {}",processName,JSON.toJSONString(vo));
        dataAdditionRectificationInformation(paramsJsonContext, executeBO);
    }

}