package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.da.service.SurveyInfoService;
import com.wlos.app.bo.*;
import com.wlos.app.da.service.SurveyProjectService;
import com.wlos.app.da.service.SurveyReformService;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 新增问卷问题记录
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class AddQuestionnaireQuestionRecordService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "新增问卷问题记录";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyInfoService surveyInfoService;
    @Autowired
    private SurveyProjectService surveyProjectService;    @Autowired
    private SurveyReformService surveyReformService;
    /**
    * 新增问卷问题记录接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(AddQuestionnaireQuestionRecordDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        AddQuestionnaireQuestionRecordBO bo = new AddQuestionnaireQuestionRecordBO();
        if (Objects.isNull(form)) {
            form = new AddQuestionnaireQuestionRecordDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算
        //数据新增-整改信息
        //参数赋值
        //运算-整改id
        //数据新增-具体问题回答
        //参数赋值
        //运算-回答id
        //数据新增-题目
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        operation(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据新增-具体问题回答
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAdditionSpecificQuestionAnswers(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddQuestionnaireQuestionRecordBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增-具体问题回答,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Integer pdbid0 = 0;
        paramMap.put("nextSurvey", pdbid0);
        Integer qntde1 = 0;
        paramMap.put("replied", qntde1);
        Long questionnaireID2 = bo.getQuestionnaireID();
        paramMap.put("questionnaireId", questionnaireID2);
        Integer calculationRectificationID3 = bo.getCalculationRectificationID();
        paramMap.put("reformId", calculationRectificationID3);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyInfoBO surveyInfoBO = BeanUtil.mapToBean(paramMap, SurveyInfoBO.class, null);
        String vo = surveyInfoService.insert(surveyInfoBO);
        bo.setDataAdditionSpecificQuestionAnswers(vo);
        log.debug("流程名称：{},方法名称: 数据新增-具体问题回答,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment_dtQR(paramsJsonContext, executeBO);
    }

    /**
    * 数据新增-题目
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAdditionQuestion(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddQuestionnaireQuestionRecordBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增-题目,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Long problemID0 = bo.getProblemID();
        paramMap.put("aid", problemID0);
        String tips1 = bo.getTips();
        paramMap.put("answerTip", tips1);
        String problem2 = bo.getProblem();
        paramMap.put("question", problem2);
        String problemType3 = bo.getProblemType();
        paramMap.put("questionType", problemType3);
        Long sort4 = bo.getSort();
        paramMap.put("sort", sort4);
        String explorationPhase5 = bo.getExplorationPhase();
        paramMap.put("surveyStep", explorationPhase5);
        Integer operationAnswerID6 = bo.getOperationAnswerID();
        paramMap.put("survey_info_id", operationAnswerID6);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyProjectBO surveyProjectBO = BeanUtil.mapToBean(paramMap, SurveyProjectBO.class, null);
        String vo = surveyProjectService.insert(surveyProjectBO);
        bo.setDataAdditionQuestion(vo);
        log.debug("流程名称：{},方法名称: 数据新增-题目,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据新增-整改信息
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAdditionRectificationInformation(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddQuestionnaireQuestionRecordBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增-整改信息,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        String operation0 = bo.getOperation();
        paramMap.put("result", operation0);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyReformBO surveyReformBO = BeanUtil.mapToBean(paramMap, SurveyReformBO.class, null);
        String vo = surveyReformService.insert(surveyReformBO);
        bo.setDataAdditionRectificationInformation(vo);
        log.debug("流程名称：{},方法名称: 数据新增-整改信息,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        AddQuestionnaireQuestionRecordBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String dataAdditionRectificationInformationpsbck0 = bo.getDataAdditionRectificationInformation();
        bo.setLocalParamRectificationID(dataAdditionRectificationInformationpsbck0);
        calculationRectificationID(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_dtQR(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        AddQuestionnaireQuestionRecordBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String dataAdditionSpecificQuestionAnswerssoxjo0 = bo.getDataAdditionSpecificQuestionAnswers();
        bo.setLocalParamAnswerID(dataAdditionSpecificQuestionAnswerssoxjo0);
        operationAnswerID(paramsJsonContext, executeBO);
    }

    /**
    * 运算-整改id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationRectificationID(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddQuestionnaireQuestionRecordBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-整改id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_biz_flow_v2_local_variable_U_ea556eb97f614ec5ada424f2687a43c8_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_local_variable_U_ea556eb97f614ec5ada424f2687a43c8_u";
        String bindType0 = "String";
        String bindValue0 = bo.getLocalParamRectificationID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setCalculationRectificationID(vo);
        log.debug("流程名称：{},方法名称: 运算-整改id,输出参数: {}",processName,JSON.toJSONString(vo));
        dataAdditionSpecificQuestionAnswers(paramsJsonContext, executeBO);
    }

    /**
    * 运算-回答id
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationAnswerID(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddQuestionnaireQuestionRecordBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-回答id,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_biz_flow_v2_local_variable_U_df365361559f49cca3792a94e768857c_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_local_variable_U_df365361559f49cca3792a94e768857c_u";
        String bindType0 = "String";
        String bindValue0 = bo.getLocalParamAnswerID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperationAnswerID(vo);
        log.debug("流程名称：{},方法名称: 运算-回答id,输出参数: {}",processName,JSON.toJSONString(vo));
        dataAdditionQuestion(paramsJsonContext, executeBO);
    }

    /**
    * 运算
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operation(JSONObject paramsJsonContext, AddQuestionnaireQuestionRecordBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddQuestionnaireQuestionRecordBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\'\';\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperation(vo);
        log.debug("流程名称：{},方法名称: 运算,输出参数: {}",processName,JSON.toJSONString(vo));
        dataAdditionRectificationInformation(paramsJsonContext, executeBO);
    }

}