package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.da.service.SurveySignService;
import com.wlos.app.bo.*;
import com.wlos.app.bo.where.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.vo.*;
/**
* 新增或更新踏勘计划签到
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class AddOrUpdSurveyPlanCheckinService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "新增或更新踏勘计划签到";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveySignService surveySignService;
    @Autowired
    private GatewayMatchService gatewayMatchService;    @Autowired
    private SurveySignAggregateService surveySignAggregateService;
    /**
    * 新增或更新踏勘计划签到接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(AddOrUpdSurveyPlanCheckinDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        AddOrUpdSurveyPlanCheckinBO bo = new AddOrUpdSurveyPlanCheckinBO();
        if (Objects.isNull(form)) {
            form = new AddOrUpdSurveyPlanCheckinDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, AddOrUpdSurveyPlanCheckinBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, AddOrUpdSurveyPlanCheckinBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据新增
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAddition(JSONObject paramsJsonContext, AddOrUpdSurveyPlanCheckinBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddOrUpdSurveyPlanCheckinBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Double longitude0 = bo.getLongitude();
        paramMap.put("latitude", longitude0);
        Double latitude1 = bo.getLatitude();
        paramMap.put("longitude", latitude1);
        String planID2 = bo.getPlanID();
        paramMap.put("planId", planID2);
        Long userID3 = bo.getUserID();
        paramMap.put("userId", userID3);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveySignBO surveySignBO = BeanUtil.mapToBean(paramMap, SurveySignBO.class, null);
        String vo = surveySignService.insert(surveySignBO);
        bo.setDataAddition(vo);
        log.debug("流程名称：{},方法名称: 数据新增,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, AddOrUpdSurveyPlanCheckinBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchDataModification(paramsJsonContext, executeBO)){
            dataModification(paramsJsonContext, executeBO);
        }
        else {
            dataAddition(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchDataModification(JSONObject paramsJsonContext, AddOrUpdSurveyPlanCheckinBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            AddOrUpdSurveyPlanCheckinBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            List dataQuery = bo.getDataQuery();
            boolean matchState = (((ObjectUtils.isNotEmpty(dataQuery))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 数据修改
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModification(JSONObject paramsJsonContext, AddOrUpdSurveyPlanCheckinBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        AddOrUpdSurveyPlanCheckinBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Long userID0 = bo.getUserID();
                paramMap.put("userId", userID0);
                LocalDateTime vsuxl1 = null;
                paramMap.put("signDate", vsuxl1);
                LocalDateTime wjouf2 = null;
                paramMap.put("modificationTime", wjouf2);
                Double longitude3 = bo.getLongitude();
                paramMap.put("latitude", longitude3);
                Double latitude4 = bo.getLatitude();
                paramMap.put("longitude", latitude4);

        JSONObject whereParamMap = new JSONObject();
                String planID5 = bo.getPlanID();
                whereParamMap.put("surveySignPlanId", planID5);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveySignBO surveySignBO = BeanUtil.mapToBean(paramMap, SurveySignBO.class, null);
        AddorupdsurveyplancheckindataModificationWhereBO addorupdsurveyplancheckindataModificationWhereBO = BeanUtil.mapToBean(whereParamMap, AddorupdsurveyplancheckindataModificationWhereBO.class, null);
        Integer vo = surveySignService.update(surveySignBO, addorupdsurveyplancheckindataModificationWhereBO);
        bo.setDataModification(vo);
        log.debug("流程名称：{},方法名称: 数据修改,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, AddOrUpdSurveyPlanCheckinBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_WzkN==");
        //调用数据查询
        AddOrUpdSurveyPlanCheckinBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveySign> vo = surveySignAggregateService.dataQuery_WzkN(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

}