package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.da.service.SurveyProjectTempService;
import com.wlos.app.bo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 新增固定问题暂存
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class AddFixedIssueTmpStgService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "新增固定问题暂存";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyProjectTempService surveyProjectTempService;

    /**
    * 新增固定问题暂存接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(AddFixedIssueTmpStgDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        AddFixedIssueTmpStgBO bo = new AddFixedIssueTmpStgBO();
        if (Objects.isNull(form)) {
            form = new AddFixedIssueTmpStgDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算
        //数据新增
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, AddFixedIssueTmpStgBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        operation(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, AddFixedIssueTmpStgBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据新增
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAddition(JSONObject paramsJsonContext, AddFixedIssueTmpStgBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddFixedIssueTmpStgBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Integer operation0 = bo.getOperation();
        paramMap.put("aid", operation0);
        String tips1 = bo.getTips();
        paramMap.put("answerTip", tips1);
        String subject2 = bo.getSubject();
        paramMap.put("question", subject2);
        Object vkual3 = "1";
        paramMap.put("questionType", vkual3);
        Long sort4 = bo.getSort();
        paramMap.put("sort", sort4);
        Long questionnaireID5 = bo.getQuestionnaireID();
        paramMap.put("questionnaireId", questionnaireID5);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyProjectTempBO surveyProjectTempBO = BeanUtil.mapToBean(paramMap, SurveyProjectTempBO.class, null);
        String vo = surveyProjectTempService.insert(surveyProjectTempBO);
        bo.setDataAddition(vo);
        log.debug("流程名称：{},方法名称: 数据新增,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 运算
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operation(JSONObject paramsJsonContext, AddFixedIssueTmpStgBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        AddFixedIssueTmpStgBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_biz_flow_v2_input_param_U_8116c850b6d24af9a1a38c3db42a2d2a_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_8116c850b6d24af9a1a38c3db42a2d2a_u";
        String bindType0 = "String";
        String bindValue0 = bo.getProblemID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperation(vo);
        log.debug("流程名称：{},方法名称: 运算,输出参数: {}",processName,JSON.toJSONString(vo));
        dataAddition(paramsJsonContext, executeBO);
    }

}