package com.wlos.app.bl;

import com.wlos.app.exception.BusinessException;
import com.wlos.app.bo.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.model.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 聚合查询
 *
 * @author
 * @date
 * @since
 */
public interface SurveyUserAggregateService {

    /**
    * 聚合查询：查询当前用户信息-数据查询
    */
    public SurveyUser dataQuery_emOB(JSONObject paramsJsonContext,QueryCurUserInformationBO bo) throws BusinessException;


    /**
    * 聚合查询：查询用户-数据查询
    */
    public List<SurveyUser> dataQuery_rqVq(JSONObject paramsJsonContext,QueryUsersBO bo) throws BusinessException;


    /**
    * 聚合查询：根据机构Id和类型查询用户列表-数据查询
    */
    public List<SurveyUser> dataQuery_khZh(JSONObject paramsJsonContext,QueryUserLstBasedOnInstitutionIDAndTypeBO bo) throws BusinessException;


    /**
    * 聚合查询：根据bcxToken获取用户信息-数据查询
    */
    public SurveyUser dataQuery_cHlc(JSONObject paramsJsonContext,ObtainUserInformationBasedOnBcxTokenBO bo) throws BusinessException;



}