package com.wlos.app.bl;

import com.wlos.app.exception.BusinessException;
import com.wlos.app.bo.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.model.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 聚合查询
 *
 * @author
 * @date
 * @since
 */
public interface SurveyTaskAggregateService {

    /**
    * 聚合查询：查询任务详情-数据查询
    */
    public SurveyTask dataQuery_dykB(JSONObject paramsJsonContext,QueryTskDetailsBO bo) throws BusinessException;


    /**
    * 聚合查询：根据用户id查询进行中的任务列-数据查询
    */
    public List<SurveyTask> dataQuery_EQSh(JSONObject paramsJsonContext,QueryOngoingTskColumnsBasedOnUserIDBO bo) throws BusinessException;


    /**
    * 聚合查询：模糊搜索任务-数据查询
    */
    public Page<DataQueryBO> dataQuery(JSONObject paramsJsonContext,FuzzySrchTskBO bo) throws BusinessException;


    /**
    * 聚合查询：不含未接受的任务列表-数据查询
    */
    public Page<DataqueryJvfiBO> dataQuery_JvFI(JSONObject paramsJsonContext,ExcludingUnacceptedTskLstBO bo) throws BusinessException;



}