package com.wlos.app.bl;

import com.wlos.app.exception.BusinessException;
import com.wlos.app.bo.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.model.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 聚合查询
 *
 * @author
 * @date
 * @since
 */
public interface SurveyPlanAggregateService {

    /**
    * 聚合查询：根据问卷id查询计划-数据查询
    */
    public SurveyPlan dataQuery_BsWD(JSONObject paramsJsonContext,QueryPlanBasedOnQuestionnaireIDBO bo) throws BusinessException;


    /**
    * 聚合查询：根据任务id查询踏勘计划次数-数据查询
    */
    public List<SurveyPlan> dataQuery_bAiC(JSONObject paramsJsonContext,QueryTheNumOfExplorationPlansBasedOnTskIDBO bo) throws BusinessException;


    /**
    * 聚合查询：根据计划id查询计划-数据查询
    */
    public SurveyPlan dataQuery_aiPC_GqBo(JSONObject paramsJsonContext,QueryPlanBasedOnPlanIDBO bo) throws BusinessException;


    /**
    * 聚合查询：根据计划id和问题类型查询问题列表-数据查询-计划
    */
    public SurveyPlan dataQuery_zloF(JSONObject paramsJsonContext,QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo) throws BusinessException;


    /**
    * 聚合查询：根据任务id查询最大计划次数-数据查询-倒序查询次数
    */
    public List<SurveyPlan> dataQuery_okFg(JSONObject paramsJsonContext,QueryMaxNumOfPlansBasedOnTskIDBO bo) throws BusinessException;


    /**
    * 聚合查询：根据任务id和次数查询勘查计划-数据查询
    */
    public List<SurveyPlan> dataQuery_sOdz(JSONObject paramsJsonContext,QueryExplorationPlanBasedOnTskIDAndNumOfTimesBO bo) throws BusinessException;


    /**
    * 聚合查询：根据任务id查询次数列表-数据查询
    */
    public List<SurveyPlan> dataQuery_CncC(JSONObject paramsJsonContext,LstOfQueryTimesBasedOnTskIDBO bo) throws BusinessException;


    /**
    * 聚合查询：更新踏勘结果-报告生成未开发-数据查询-未作答题目记录
    */
    public List<DataqueryAuhnBO> dataQuery_AuHN(JSONObject paramsJsonContext,UpdSurveyResultsReportGenerationUndevelopedBO bo) throws BusinessException;


    /**
    * 聚合查询：问卷设计列表查询-数据查询-计划列表
    */
    public List<DataqueryRmqqBO> dataQuery_rMQq(JSONObject paramsJsonContext,QuestionnaireDesignLstQueryBO bo) throws BusinessException;


    /**
    * 聚合查询：根据年月份查询未完成的任务列表-数据查询
    */
    public List<DataqueryBcejBO> dataQuery_BcEj(JSONObject paramsJsonContext,QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO bo) throws BusinessException;


    /**
    * 聚合查询：根据计划id查询计划详情-数据查询
    */
    public DataqueryAipcBO dataQuery_aiPC(JSONObject paramsJsonContext,QueryPlanDetailsBasedOnPlanIDBO bo) throws BusinessException;


    /**
    * 聚合查询：根据计划id查询计划信息-数据查询-踏勘计划
    */
    public DataqueryGstwBO dataQuery_gsTW(JSONObject paramsJsonContext,QueryPlanInformationBasedOnPlanIDBO bo) throws BusinessException;



}