package com.wlos.app.bl;

import com.wlos.app.exception.BusinessException;
import com.wlos.app.bo.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.model.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 聚合查询
 *
 * @author
 * @date
 * @since
 */
public interface SurveyInfoAggregateService {

    /**
    * 聚合查询：根据问卷id查询所有问题列表-数据查询
    */
    public List<DataqueryOouxBO> dataQuery_OouX(JSONObject paramsJsonContext,QueryAllQuestionListsBasedOnQuestionnaireIDBO bo) throws BusinessException;


    /**
    * 聚合查询：根据回答id查询问题信息-数据查询-问题详情
    */
    public DataqueryKbpxBO dataQuery_kBPx(JSONObject paramsJsonContext,QueryQuestionInformationBasedOnAnswerIDBO bo) throws BusinessException;


    /**
    * 聚合查询：下一题-数据查询-查之后的题目
    */
    public List<DataqueryVlalBO> dataQuery_VLaL(JSONObject paramsJsonContext,NxtQuestionBO bo) throws BusinessException;


    /**
    * 聚合查询：生成问卷-问卷的问题列表
    */
    public List<SurveyInfo> dataQuery_rLQS(JSONObject paramsJsonContext,GenQuestionnaireBO bo) throws BusinessException;


    /**
    * 聚合查询：根据计划id和问题类型查询问题列表-数据查询-问题
    */
    public List<DataqueryGxahBO> dataQuery_gXAH(JSONObject paramsJsonContext,QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo) throws BusinessException;


    /**
    * 聚合查询：根据计划id和问题类型查询问题列表-数据查询-已答问题
    */
    public List<DataqueryYsjpBO> dataQuery_YsjP(JSONObject paramsJsonContext,QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo) throws BusinessException;



}