package com.wlos.app.api;

import com.wlos.app.model.SurveyProjectTemp;
import com.wlos.app.utils.*;
import com.wlos.app.da.service.SurveyProjectTempService;
import com.wlos.app.model.vo.OperateCondition;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.lang3.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.*;


/**
 * 问卷题目暂存表服务
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
@RestController
@RequestMapping(Constants.REQUEST_MAPPING_PREFIX)
public class SurveyProjectTempController {

    @Autowired
    private SurveyProjectTempService surveyProjectTempService;


    /**
     * 根据id查询问卷题目暂存表
     *
     * @param id 问卷题目暂存表Id
     * @return 单条数据结果
     */
    @GetMapping("/v1/surveyProjectTemp/{id}")
    public Result<SurveyProjectTemp> getById(@PathVariable String id) {
        SurveyProjectTemp surveyProjectTemp = surveyProjectTempService.queryById(id);
        return Result.SUCCESS(surveyProjectTemp);
    }

    /**
     * 根据id列表查询问卷题目暂存表
     *
     * @param ids 问卷题目暂存表Ids
     * @return 列表数据集 
     */
    @PostMapping("/v1/surveyProjectTemp/batch")
    public Result<List<SurveyProjectTemp>> getByIds(@RequestBody List<String> ids) {
        List<SurveyProjectTemp> surveyProjectTempList = surveyProjectTempService.listByIds(ids);
        return Result.SUCCESS(surveyProjectTempList);
    }


    /**
     * 多组集合数据去重合并
     *
     * @param list 需要合并list集合数据 
     * @return 合并后列表数据集 
     */
    @PostMapping("/v1/surveyProjectTemp/merge")
    public Result<Set<SurveyProjectTemp>> merge(@RequestBody List<List<SurveyProjectTemp>> list) {
        Set<SurveyProjectTemp> newMergedList = new HashSet<>();

        for (List<SurveyProjectTemp> item : list) {
            newMergedList.addAll(item);
        }

        return Result.SUCCESS(newMergedList);
    }


    /**
     * 获取集合列表的主键集合
     *
     * @param list 数据
     * @return 主键集合 
     */
    @PostMapping("/v1/surveyProjectTemp/extract")
    public Result<List<String>> extract(@RequestBody List<SurveyProjectTemp> list) {
        List<String> idList = list.stream().map(SurveyProjectTemp::getId).toList();

        return Result.SUCCESS(idList);
    }


    /**
     * 根据条件查询问卷题目暂存表
     *
     * @param condition 条件
     * @return 单条数据结果
     */
    @GetMapping("/v1/surveyProjectTemp/one")
    public Result<SurveyProjectTemp> one(SurveyProjectTemp condition) {
        SurveyProjectTemp surveyProjectTemp = surveyProjectTempService.getOne(new QueryWrapper<>(condition));
        return Result.SUCCESS(surveyProjectTemp);
    }


    /**
     * 条件查询总行数count
     *
     * @param condition 条件
     * @return 总行数
     */
    @GetMapping("/v1/surveyProjectTemp/count")
    public Result<Long> count(SurveyProjectTemp condition) {
        long count = surveyProjectTempService.count(new QueryWrapper<>(condition));
        return Result.SUCCESS(count);
    }


    /**
     * 简单聚合函数查询
     *
     * @param func       函数类型
     * @param funcColumn 函数处理字段
     * @param condition  查询条件
     * @return 统计后数据
     */
    @GetMapping("/v1/surveyProjectTemp/func")
    public Result<Map<String, Object>> funcWithSimple(@RequestParam String func, @RequestParam(required = false) String funcColumn, SurveyProjectTemp condition) {
        QueryWrapper<SurveyProjectTemp> codeTemplateQueryWrapper = FuncUtils.funSimple(func, funcColumn, condition);
        List<Map<String, Object>> maps = surveyProjectTempService.listMaps(codeTemplateQueryWrapper);
        Map<String, Object> result = null;
        if (ObjectUtils.isNotEmpty(maps)) {
            result = maps.get(0);
        }
        return Result.SUCCESS(result);
    }


    /**
     * 带分组条件聚合函数查询
     *
     * @param operateCondition 函数参数
     * @return 分组统计后数据
     */
    @PostMapping("/v1/surveyProjectTemp/funcByGroup")
    public Result<List<Map<String, Object>>> countByGroup(@RequestBody OperateCondition operateCondition) {
        QueryWrapper<SurveyProjectTemp> codeTemplateQueryWrapper = FuncUtils.funcByGroup(operateCondition);
        List<Map<String, Object>> maps = surveyProjectTempService.listMaps(codeTemplateQueryWrapper);
        return Result.SUCCESS(maps);
    }




    /**
     * 列表分页条件查询 问卷题目暂存表
     * @param pageNum  页码
     * @param pageSize 页数
     * @param condition 条件
     * @return 列表数据
     */
    @GetMapping("/v1/surveyProjectTemp/page")
    public Result<Page<SurveyProjectTemp>> page(@RequestParam(required = false) Long pageNum,
                                            @RequestParam(required = false) Long pageSize,
                                            SurveyProjectTemp condition) {
        Page<SurveyProjectTemp> pageResult = surveyProjectTempService.page(new Page<>(pageNum, pageSize), condition);                                           
        return Result.SUCCESS(pageResult);
    }


    /**
     * 列表不分页条件查询 问卷题目暂存表
     * @param condition 条件
     * @return 列表数据
     */
    @GetMapping("/v1/surveyProjectTemp/list")
    public Result<List<SurveyProjectTemp>> list(SurveyProjectTemp condition) {
        List<SurveyProjectTemp> listResult = surveyProjectTempService.list(new QueryWrapper<>(condition));                                           
        return Result.SUCCESS(listResult);
    }


    /**
     * 列表不分页复杂条件查询 {cnName}
     * @param condition 条件
     * @return 列表数据
     */
    @PostMapping("/v1/surveyProjectTemp/condition/list")
    public Result<List<SurveyProjectTemp>> list(@RequestBody OperateCondition condition) {
        QueryWrapper<SurveyProjectTemp> queryWrapper = new QueryWrapper<>();
        FuncUtils.buildWhere(condition.getWhereList(),queryWrapper);
        List<SurveyProjectTemp> list = surveyProjectTempService.list(queryWrapper);
        return Result.SUCCESS(list);
    }




    /**
     * 创建问卷题目暂存表
     *
     * @param surveyProjectTemp 问卷题目暂存表载体
     * @return 问卷题目暂存表 主键
     */
    @PostMapping("/v1/surveyProjectTemp")
    public Result<String> create(@RequestBody SurveyProjectTemp surveyProjectTemp){
        return Result.SUCCESS(surveyProjectTempService.insert(surveyProjectTemp));
    }


    /**
     * 根据主键更新问卷题目暂存表
     *
     * @param id 问卷题目暂存表ID
     * @param surveyProjectTemp 问卷题目暂存表载体
     * @return Id
     */
    @PutMapping("/v1/surveyProjectTemp/{id}")
    public Result<Integer> update(@PathVariable String id, @RequestBody SurveyProjectTemp surveyProjectTemp){
        return Result.SUCCESS(surveyProjectTempService.update(id, surveyProjectTemp));
    }


    /**
     * 根据主键删除问卷题目暂存表
     *
     * @param id 问卷题目暂存表ID
     * @return
     */
    @DeleteMapping("/v1/surveyProjectTemp/{id}")
    public Result<Void> deleteById(@PathVariable String id){
        surveyProjectTempService.deleteById(id);
        return Result.SUCCESS();
    }


    /**
     * 根据主键集合批量删除问卷题目暂存表
     *
     * @param ids 问卷题目暂存表id集合
     * @return
     */
    @DeleteMapping("/v1/surveyProjectTemp/batch")
    public Result<Void> deleteByIds(@RequestBody List<String> ids){
        surveyProjectTempService.deleteByIds(ids);
        return Result.SUCCESS();
    }


}