package com.wlos.app.api;

import com.wlos.app.utils.Constants;
import com.wlos.app.utils.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName PluginQiniuController
 * @Author Tazerotoo
 * @Date 2024/2/5 16:28
 * 七牛插件api
 */
@RestController
@RequestMapping(Constants.REQUEST_MAPPING_PREFIX)
public class PluginQiniuController {

    private static final Logger log = LoggerFactory.getLogger(PluginQiniuController.class);

    /**
     * 获取七牛上传token
     * @param uuid
     * @param fileName
     * @return
     */
    @GetMapping("/sysPlugin/getQnUploadToken")
    public Result<Map<String, Object>> getQnUploadToken2(@RequestParam String uuid, @RequestParam String fileName) {
        com.wlsk.plugin.qiniu.bl.QiniuService resourceService = com.wlos.app.utils.BeanUtils.getBean(com.wlsk.plugin.qiniu.bl.QiniuService.class);
        Map<String, Object> vo = new HashMap<>();

        String uploadToken = resourceService.getUploadToken(uuid, fileName);
        String basePath = resourceService.getBasePath();

        vo.put("token",uploadToken);
        vo.put("basePath",basePath);
        return Result.SUCCESS(vo);
    }
}