package com.wlos.app.api;

import com.wlos.app.utils.Result;
import com.wlos.app.bl.IdempotentService;
import com.wlos.app.aop.IdempotentCheck;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName IdempotentController
 * @Author Tazerotoo
 * @Date 2023/11/20 17:38
 * 防重
 */
@RestController
@RequestMapping("/api/common")
public class IdempotentController {

    @Autowired
    private IdempotentService idempotentService;

    /**
     * 获取 幂等 token
     * @return
     */
    @GetMapping("/idempotentToken")
    public Result<String> getIdempotentToken(){
        String vo = idempotentService.getIdempotentToken();
        return Result.SUCCESS(vo,"success");
    }

    /**
     * 测试 幂等 token
     * @return
     */
    @IdempotentCheck
    @PostMapping("/test")
    public Result<String> testIdempotent(){
        return Result.SUCCESS();
    }
}
