package com.wlos.app.aop;

import com.wlos.app.utils.RedisUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component
@EnableAspectJAutoProxy
@Scope
@Aspect
public class IdempotentCheckAop {

    private transient Logger log = LoggerFactory.getLogger(getClass());
 
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private RedisUtil redisUtil;


    @Pointcut("@annotation(IdempotentCheck)")
    public void serviceAspect() {
 
    }
 
    @Around("serviceAspect()")
    public Object around(ProceedingJoinPoint joinPoint) {
        String idempotentToken = request.getHeader("X-Idempotent-Token");
        String requestURI = request.getRequestURI();
        log.debug("IdempotentCheckAop : {} ---- {}", idempotentToken,requestURI);
        if (ObjectUtils.isEmpty(idempotentToken)) {
            throw new BusinessException("header IdempotentToken is null ！");
        }
        Object idempotentTokenCatch = redisUtil.get(idempotentToken);
        if (ObjectUtils.isEmpty(idempotentTokenCatch)) {
            throw new BusinessException("请勿重复提交！");
        }
        redisUtil.del(idempotentToken);
        Object voObj;
        try {
            voObj = joinPoint.proceed();

        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
        log.debug("voObj : {}", voObj);
        return voObj;
    }
 
    public void resp(HttpServletResponse response, String msg) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            outputStream.write(msg.getBytes("UTF-8"));
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            outputStream.flush();
            outputStream.close();
        }
    }
}