package com.wlos.app;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableAsync;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.ComponentScan;
import java.util.TimeZone;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@EnableAsync
@SpringBootApplication
@ComponentScan(value = {
        "com.wlsk.plugin.qiniu",
})
@ComponentScan(value = {
        "com.wlos.app",
        "com.weilaios.wlos",
})

@org.springframework.cloud.openfeign.EnableFeignClients({
	"com.wlsk.plugin.qiniu",

})
public class QxVIGwYVApplication {

    public static void main(String[] args) {
        SpringApplication.run(QxVIGwYVApplication.class, args);
    }
    @PostConstruct
    void started() {
        //时区设置：中国上海
        TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
    }
}