/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.config.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"com.bcxin.oaflow.mapper"}, sqlSessionFactoryRef="oaflowSqlSessionFactory")
public class OaFlowDSConfig {
    private final String mapperLocation = "classpath:mapper/oaflow/*.xml";

    @Bean(name={"oaflowDataSource"})
    @ConfigurationProperties(prefix="oaflow.datasource")
    public DataSource oaflowDataSource() {
        return new DruidDataSource();
    }

    @Bean(name={"oaflowSqlSessionFactory"})
    @ConditionalOnBean(name={"oaflowDataSource"})
    public SqlSessionFactory oaflowSqlSessionFactory(@Qualifier(value="oaflowDataSource") DataSource oaflowDataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(oaflowDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/oaflow/*.xml"));
        return sessionFactory.getObject();
    }
}

