/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.meeting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.meeting.ComHuaweiMeetMatch;
import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import com.bcxin.platform.dto.meeting.AddCorpDTO;
import com.bcxin.platform.dto.meeting.AdminDTO;
import com.bcxin.platform.dto.meeting.AttendeeDTO;
import com.bcxin.platform.dto.meeting.ComHuaweiMeetMatchDto;
import com.bcxin.platform.dto.meeting.CorpBasicDTO;
import com.bcxin.platform.dto.meeting.ModVmrDto;
import com.bcxin.platform.dto.meeting.PerHuaweiMeetMatchDto;
import com.bcxin.platform.dto.meeting.RestScheduleConfDTO;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.meeting.ComHuaweiMeetMatchMapper;
import com.bcxin.platform.mapper.meeting.PerHuaweiMeetMatchMapper;
import com.bcxin.platform.service.cache.TaskCacheService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.meeting.ComHuaweiMeetMatchService;
import com.bcxin.platform.util.http.MD5Util;
import com.bcxin.platform.util.huawei.HttpBuildUtil;
import com.bcxin.platform.util.huawei.RestRequest;
import com.bcxin.platform.util.huawei.RestResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ComHuaweiMeetMatchServiceImpl
implements ComHuaweiMeetMatchService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private PerHuaweiMeetMatchMapper perHuaweiMeetMatchMapper;
    @Resource
    private ComHuaweiMeetMatchMapper comHuaweiMeetMatchMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private TaskCacheService taskCacheService;
    @Resource
    private CommonService commonService;
    @Resource
    private IdWorker idWorker;

    @Override
    public ComHuaweiMeetMatch selectComHuaweiMeetMatchById(Long comId) {
        return this.comHuaweiMeetMatchMapper.selectComHuaweiMeetMatchById(comId);
    }

    @Override
    public List<ComHuaweiMeetMatchDto> selectComHuaweiMeetMatchList(ComHuaweiMeetMatchDto comHuaweiMeetMatch) {
        return this.comHuaweiMeetMatchMapper.selectComHuaweiMeetMatchList(comHuaweiMeetMatch);
    }

    @Override
    public int saveComHuaweiMeetMatch(ComHuaweiMeetMatch comHuaweiMeetMatch) throws PlatFormBusinessException {
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoById(comHuaweiMeetMatch.getComId());
        if (comBaseInfo == null) {
            throw new PlatFormBusinessException("comId\u65e0\u6548");
        }
        if (this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(comHuaweiMeetMatch.getComId()) != null) {
            throw new PlatFormBusinessException("\u534e\u4e3a\u4e91\u4f01\u4e1a\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        String comCerNo = comBaseInfo.getComCerNo();
        String account = "HW_" + comCerNo;
        String pwd = MD5Util.string2MD5("Saas@" + comCerNo.substring(comCerNo.length() - 6, comCerNo.length())).substring(4, 16);
        Result result = this.buildCompanyByAdmin(comBaseInfo.getComName(), account, pwd);
        if ("0".equals(result.getRetType())) {
            String Id = String.valueOf(result.getData());
            comHuaweiMeetMatch.setHuaweiManageUserName(account);
            comHuaweiMeetMatch.setHuaweiComId(Long.parseLong(Id));
            comHuaweiMeetMatch.setHuaweiManagePassWord(pwd);
            comHuaweiMeetMatch.setCreateTime(DateUtils.getNowDate());
            return this.comHuaweiMeetMatchMapper.save(comHuaweiMeetMatch);
        }
        throw new PlatFormBusinessException(result.getMsg());
    }

    private Result buildCompanyByAdmin(String companyName, String account, String pwd) throws PlatFormBusinessException {
        AddCorpDTO acDTO = new AddCorpDTO();
        AdminDTO adminInfo = new AdminDTO();
        adminInfo.setAccount(account);
        adminInfo.setPwd(pwd);
        adminInfo.setName(companyName);
        adminInfo.setEmail(this.commonService.getSystemConfig("MEET_BUILD_SP_EMAIL"));
        acDTO.setAdminInfo(adminInfo);
        CorpBasicDTO basicInfo = new CorpBasicDTO();
        basicInfo.setName(companyName);
        acDTO.setBasicInfo(basicInfo);
        String accessToken = this.commonService.getComManageHuaweiMeetAccessToken(this.commonService.getSystemConfig("MEET_MANAGE_SP_USER"), this.commonService.getSystemConfig("MEET_MANAGE_SP_PWD"), this.commonService.getSystemConfig("MEET_MANAGE_SP_COMID"));
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/sp/corp";
        String param = JSON.toJSONString((Object)acDTO);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        this.logger.info(" ========== \u7ba1\u7406\u5458\u521b\u5efa\u4f01\u4e1a\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        Map<String, Object> map = HttpBuildUtil.getMapData(response);
        if (map == null) {
            if (map.get("error_msg") != null) {
                return Result.fail((String)map.get("error_msg").toString());
            }
            return Result.fail((String)"\u672a\u83b7\u53d6\u5230\u4f01\u4e1aID!");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)map.get("value"));
    }

    @Override
    public int updateComHuaweiMeetMatch(ComHuaweiMeetMatch comHuaweiMeetMatch) {
        if (comHuaweiMeetMatch.getComId() == null) {
            comHuaweiMeetMatch.setCreateTime(DateUtils.getNowDate());
            comHuaweiMeetMatch.setComId(this.idWorker.nextId());
        } else {
            ComHuaweiMeetMatch dbComHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.selectComHuaweiMeetMatchById(comHuaweiMeetMatch.getComId());
            BeanUtils.copyPropertiesIgnore((Object)comHuaweiMeetMatch, (Object)dbComHuaweiMeetMatch, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbComHuaweiMeetMatch, (Object)comHuaweiMeetMatch, (Boolean)false);
        }
        return this.comHuaweiMeetMatchMapper.save(comHuaweiMeetMatch);
    }

    @Override
    public int deleteComHuaweiMeetMatchByIds(String ids) {
        return this.comHuaweiMeetMatchMapper.deleteComHuaweiMeetMatchByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deleteComHuaweiMeetMatchById(Long comId) {
        return this.comHuaweiMeetMatchMapper.deleteComHuaweiMeetMatchById(comId);
    }

    @Override
    public Result getComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) throws PlatFormBusinessException {
        ComHuaweiMeetMatch comHuaweiMeetMatch1 = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(comHuaweiMeetMatch.getComId());
        return Result.success((String)"", (Object)comHuaweiMeetMatch1);
    }

    @Override
    public Result getHuaweiManageResource(PerHuaweiMeetMatch perHuaweiMeetMatch) throws PlatFormBusinessException {
        ComHuaweiMeetMatch comHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(perHuaweiMeetMatch.getComId());
        if (comHuaweiMeetMatch == null) {
            return Result.fail((String)"\u60a8\u6240\u5728\u4f01\u4e1a\u8fd8\u672a\u8d2d\u4e70\u4f1a\u8bae\u8d44\u6e90");
        }
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(perHuaweiMeetMatch.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), perHuaweiMeetMatch.getPerId());
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/resource";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"", HttpBuildUtil.getMapData(response));
    }

    @Override
    public Result buildHuaweiMeet(RestScheduleConfDTO restScheduleConfDTO) throws PlatFormBusinessException {
        PerHuaweiMeetMatch meetMatch;
        if (restScheduleConfDTO.getMediaTypes() == null) {
            return Result.fail((String)"\u4f1a\u8bae\u7684\u5a92\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)restScheduleConfDTO.getAttendeesJSON())) {
            restScheduleConfDTO.setAttendees(JSON.parseArray((String)restScheduleConfDTO.getAttendeesJSON(), AttendeeDTO.class));
        }
        if ((meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(restScheduleConfDTO.getPerId())) == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), meetMatch.getPerId());
        String url = "https://api.meeting.huaweicloud.com/v1/mmc/management/conferences";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        String param = JSON.toJSONString((Object)restScheduleConfDTO);
        this.logger.info(" ========== \u9884\u7ea6\u4f1a\u8bae\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        JSONArray arr = JSON.parseArray((String)response.getEntity());
        return Result.success((String)"", (Object)arr);
    }

    @Override
    public Result getHuaweiUserDetail(PerHuaweiMeetMatch perHuaweiMeetMatch) throws PlatFormBusinessException {
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(perHuaweiMeetMatch.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), meetMatch.getPerId());
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/member";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        this.logger.info(" ========== \u7528\u6237\u67e5\u8be2\u81ea\u5df1\u7684\u4fe1\u606f");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"", HttpBuildUtil.getMapData(response));
    }

    @Override
    public Result getHuaweiCloudMeetRoomList(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u6761\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComHuaweiMeetMatch comHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(dto.getComId());
        if (comHuaweiMeetMatch == null) {
            return Result.fail((String)"\u60a8\u6240\u5728\u4f01\u4e1a\u8fd8\u672a\u8d2d\u4e70\u4f1a\u8bae\u8d44\u6e90");
        }
        String accessToken = this.taskCacheService.getComManageHuaweiMeetAccessToken(comHuaweiMeetMatch.getHuaweiManageUserName(), comHuaweiMeetMatch.getHuaweiManagePassWord(), dto.getComId());
        if (StringUtils.isEmpty((String)accessToken)) {
            return Result.fail((String)"\u534e\u4e3a\u4e91\u4f1a\u8bae\u9274\u6743\u5931\u8d25");
        }
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/vmr";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("offset", String.valueOf(dto.getPageNumber() - 1));
        map.put("limit", dto.getPageSize().toString());
        if (StringUtils.isNotEmpty((String)dto.getKeyWord())) {
            map.put("searchKey", dto.getKeyWord());
        }
        map.put("status", dto.getStatus());
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"", HttpBuildUtil.getMapData(response));
    }

    @Override
    public Result updateHuaweiCloudMemberVmr(ModVmrDto dto) throws PlatFormBusinessException {
        if (StringUtils.isEmpty((String)dto.getId())) {
            return Result.fail((String)"\u4e91\u4f1a\u8bae\u5ba4\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dto.setBool();
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), meetMatch.getPerId());
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/member/vmr/" + dto.getId();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vmrName", dto.getVmrName());
        map.put("gustPwd", dto.getGustPwd());
        map.put("chairPwd", dto.getChairPwd());
        map.put("allowGustFirst", dto.getAllowGustFirst());
        map.put("gustFirstNotice", dto.getGustFirstNotice());
        String param = JSON.toJSONString(map);
        this.logger.info(" ========== \u4fee\u6539\u7528\u6237\u4e91\u4f1a\u8bae\u5ba4\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("PUT", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result recycleFromMember(ModVmrDto dto) throws PlatFormBusinessException {
        if (StringUtils.isEmpty((String)dto.getAccount())) {
            return Result.fail((String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getVmrIdList())) {
            return Result.fail((String)"\u4e91\u4f1a\u8bae\u5ba4\u552f\u4e00ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComHuaweiMeetMatch comHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(dto.getComId());
        if (comHuaweiMeetMatch == null) {
            return Result.fail((String)"\u60a8\u6240\u5728\u4f01\u4e1a\u8fd8\u672a\u8d2d\u4e70\u4f1a\u8bae\u8d44\u6e90");
        }
        String accessToken = this.taskCacheService.getComManageHuaweiMeetAccessToken(comHuaweiMeetMatch.getHuaweiManageUserName(), comHuaweiMeetMatch.getHuaweiManagePassWord(), dto.getComId());
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/vmr/recycle-from-member/" + dto.getAccount();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        String param = dto.getVmrIdList();
        this.logger.info(" ========== \u56de\u6536\u4e13\u7528\u4e91\u4f1a\u8bae\u5ba4\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result assignToMember(ModVmrDto dto) throws PlatFormBusinessException {
        if (StringUtils.isEmpty((String)dto.getAccount())) {
            return Result.fail((String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getVmrIdList())) {
            return Result.fail((String)"\u4e91\u4f1a\u8bae\u5ba4\u552f\u4e00ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComHuaweiMeetMatch comHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(dto.getComId());
        if (comHuaweiMeetMatch == null) {
            return Result.fail((String)"\u60a8\u6240\u5728\u4f01\u4e1a\u8fd8\u672a\u8d2d\u4e70\u4f1a\u8bae\u8d44\u6e90");
        }
        String accessToken = this.taskCacheService.getComManageHuaweiMeetAccessToken(comHuaweiMeetMatch.getHuaweiManageUserName(), comHuaweiMeetMatch.getHuaweiManagePassWord(), dto.getComId());
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/vmr/assign-to-member/" + dto.getAccount();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        String param = dto.getVmrIdList();
        this.logger.info(" ========== \u5206\u914d\u4e13\u7528\u4e91\u4f1a\u8bae\u5ba4\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result deleteMemberVmr(ModVmrDto dto) throws PlatFormBusinessException {
        if (StringUtils.isEmpty((String)dto.getVmrIdList())) {
            return Result.fail((String)"\u4e91\u4f1a\u8bae\u5ba4\u552f\u4e00ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComHuaweiMeetMatch comHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(dto.getComId());
        if (comHuaweiMeetMatch == null) {
            return Result.fail((String)"\u60a8\u6240\u5728\u4f01\u4e1a\u8fd8\u672a\u8d2d\u4e70\u4f1a\u8bae\u8d44\u6e90");
        }
        String accessToken = this.taskCacheService.getComManageHuaweiMeetAccessToken(comHuaweiMeetMatch.getHuaweiManageUserName(), comHuaweiMeetMatch.getHuaweiManagePassWord(), dto.getComId());
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/vmr/delete";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        String param = dto.getVmrIdList();
        this.logger.info(" ========== \u5220\u9664\u4e13\u7528\u4e91\u4f1a\u8bae\u5ba4\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getHuaweiCloudMemberVmrList(ModVmrDto dto) throws PlatFormBusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u6761\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), meetMatch.getPerId());
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/member/vmr";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("offset", String.valueOf(dto.getPageNumber() - 1));
        map.put("limit", dto.getPageSize().toString());
        if (StringUtils.isNotEmpty((String)dto.getSearchKey())) {
            map.put("searchKey", dto.getSearchKey());
        }
        Boolean specialVmr = null;
        if (StringUtils.isNotEmpty((String)dto.getSpecialVmr())) {
            specialVmr = "1".equals(dto.getSpecialVmr()) ? true : ("0".equals(dto.getSpecialVmr()) ? Boolean.valueOf(false) : null);
        }
        map.put("specialVmr", specialVmr == null ? "" : String.valueOf(specialVmr));
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"", HttpBuildUtil.getMapData(response));
    }

    @Override
    public int refreshComHuaweiMeet(Long comId) {
        this.commonService.deleteRedisByKey("huaweiMeetCom" + comId);
        return 1;
    }
}

