package com.bcxin.platform.timer;

import cn.hutool.core.util.StrUtil;
import com.bcxin.oaflow.domain.*;
import com.bcxin.oaflow.dto.OaBusinessDto;
import com.bcxin.oaflow.mapper.*;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.domain.attend.AttendClock;
import com.bcxin.platform.domain.attend.AttendLeave;
import com.bcxin.platform.domain.attend.AttendReport;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.mapper.attend.AttendClockMapper;
import com.bcxin.platform.mapper.attend.AttendReportMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendLeaveService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2021/08/30 0030 17:22
 */
@Component("attendReportTask")
public class AttendReportTask {

    @Resource
    private AttendReportMapper attendReportMapper;

    @Resource
    private AttendClockMapper attendClockMapper;

    @Resource
    private LeaveApplicationMapper leaveApplicationMapper;

    @Resource
    private BusinessTravelMapper businessTravelMapper;

    @Resource
    private PublicReleaseMapper publicReleaseMapper;

    @Resource
    private WorkOvertimeMapper workOvertimeMapper;

    @Resource
    private MakeUpCardMapper makeUpCardMapper;

    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;

    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;

    @Resource
    private AttendLeaveService attendLeaveService;

    @Resource
    private IdWorker idWorker;


    public void createDayReport(){
        createDayReport(DateUtil.getYesterday(),true,null);
    }


    public void manualCreateDayReport(String schedulDate){
        createDayReport(schedulDate,false,null);
    }

    public void manualCreateDayReports(String startDate,String endDate){
        attendClockMapper.createAbsence();
        attendClockMapper.updateClockStatus();
        List<Date> dates = DateUtil.getBetweenDates(startDate,endDate);
        for (Date date : dates) {
            createDayReport(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date),false,null);
        }
    }

    /**
     * 生成日结果统计
     * @param schedulDate
     */
    public void createDayReport(String schedulDate,Boolean clockStatus,Long perId){
        if(clockStatus) {
            attendClockMapper.createAbsence();
            attendClockMapper.updateClockStatus();
        }

        List<AttendLeave> attendLeaveList = new ArrayList<>();
        AttendClockDto searchDto = new AttendClockDto();
        searchDto.setSchedulDate(schedulDate);
        searchDto.setPerId(perId);
        List<AttendClockDto> list = attendClockMapper.selectListForReport(searchDto);
        if(list.size() == 0){
            return;
        }
        List<String> tlkPerIds = list.stream().map(AttendClockDto::getTlkPerId).distinct().collect(Collectors.toList());

        List<LeaveApplication> leaveList = leaveApplicationMapper.selectList(tlkPerIds, schedulDate);
        List<BusinessTravel> businessTravelList = businessTravelMapper.selectList(tlkPerIds, schedulDate);
        List<PublicRelease> publicReleaseList = publicReleaseMapper.selectList(tlkPerIds, schedulDate);
        List<WorkOvertime> overtimeList = workOvertimeMapper.selectList(tlkPerIds, schedulDate);
        Map<String,List<AttendClockDto>> clockMap = list.stream().collect(Collectors.groupingBy(AttendClockDto::getTlkPerId));
        Map<String,List<LeaveApplication>> leaveMap = leaveList.stream().collect(Collectors.groupingBy(LeaveApplication::getUserId));
        Map<String,List<BusinessTravel>> businessTraveMap = businessTravelList.stream().collect(Collectors.groupingBy(BusinessTravel::getUserId));
        Map<String,List<PublicRelease>> publicReleaseMap = publicReleaseList.stream().collect(Collectors.groupingBy(PublicRelease::getUserId));
        Map<String,WorkOvertime> overtimeMap = overtimeList.stream().collect(Collectors.toMap(WorkOvertime::getUserId, Function.identity()));

        /** 旷工时数 */
        Double absenteeism = 0.0D;
        /** 早退分钟数 */
        Integer leaveEarly = 0;
        /** 迟到分钟数 */
        Integer lateMin = 0;
        /** 漏卡次数 */
        Integer missCard = 0;
        /** 请假时数 */
        Double leaveHour = 0.0D;
        /** 公出时数 */
        Double businessOut = 0.0D;
        /** 加班时数 */
        Double overtime = 0.0D;
        /** 出差时数 */
        Double businessTrip = 0.0D;
        /** 实际出勤时数 */
        Double workHour = 0.0D;

        boolean updateFlag = false;

        String attendClockStatus = null;

        List<AttendClock> clockList = new ArrayList<>();
        for (String tlkPerId : clockMap.keySet()) {
            List<AttendClockDto> subList = clockMap.get(tlkPerId);
            List<LeaveApplication> subLeaveList = leaveMap.get(tlkPerId);
            List<BusinessTravel> subTravelList = businessTraveMap.get(tlkPerId);
            List<PublicRelease> subReleaseList = publicReleaseMap.get(tlkPerId);

            /*加班*/
            WorkOvertime workOvertime = overtimeMap.get(tlkPerId);
            if(workOvertime != null) {
                /** 加班时数 */
                overtime = workOvertime.getDiffTime();
            }

            for (AttendClockDto attendClockDto : subList) {
                if(attendClockDto.getShiftHour() == null){
                    attendClockDto.setShiftHour(0.0D);
                }
                attendClockStatus = attendClockDto.getClockStatus();
                updateFlag = false;
                /** 旷工时数 */
                absenteeism = 0.0D;
                /** 早退分钟数 */
                leaveEarly = 0;
                /** 迟到分钟数 */
                lateMin = 0;
                /** 漏卡次数 */
                missCard = 0;
                /** 请假时数 */
                leaveHour = 0.0D;
                /** 公出时数 */
                businessOut = 0.0D;
                /** 出差时数 */
                businessTrip = 0.0D;
                /** 实际出勤时数 */
                workHour = 0.0D;

                //List<OaBusinessBaseEntity> businessList = new ArrayList<>();


                //迟到
                if(DictConst.CLOCKSTATUS_3.equals(attendClockDto.getClockStatus()) || DictConst.CLOCKSTATUS_23.equals(attendClockDto.getClockStatus()) || DictConst.CLOCKSTATUS_34.equals(attendClockDto.getClockStatus())){
                    lateMin = attendClockDto.getLateMin();
                }
                //早退
                if(DictConst.CLOCKSTATUS_4.equals(attendClockDto.getClockStatus()) || DictConst.CLOCKSTATUS_24.equals(attendClockDto.getClockStatus()) || DictConst.CLOCKSTATUS_34.equals(attendClockDto.getClockStatus())){
                    leaveEarly = attendClockDto.getLeaveEarly();
                }

                //旷工时数
                if(DictConst.CLOCKSTATUS_5.equals(attendClockDto.getClockStatus())){
                    if(DictConst.SHIFTTYPE_JSBC.equals(attendClockDto.getShiftType())) {
                        missCard = 2;
                        absenteeism = attendClockDto.getShiftHour();
                    }else{
                        missCard = 1;
                    }
                }
                //漏卡
                if(DictConst.CLOCKSTATUS_21.equals(attendClockDto.getClockStatus())
                        || DictConst.CLOCKSTATUS_22.equals(attendClockDto.getClockStatus())
                        || DictConst.CLOCKSTATUS_23.equals(attendClockDto.getClockStatus())
                        || DictConst.CLOCKSTATUS_24.equals(attendClockDto.getClockStatus())) {
                    //漏卡次数
                    missCard = 1;
                }

                if(DictConst.SHIFTTYPE_JSBC.equals(attendClockDto.getShiftType())) {
                    //计时班次才与0A审批挂勾
                    /*请假*/
                    if (subLeaveList != null) {
                        for (LeaveApplication businessEntity : subLeaveList) {
                            Double minute = calculateMinute(businessEntity, attendClockDto);
                            if (minute > 0) {
                                Double hour = BigDecimal.valueOf(minute / 60.0).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                                leaveHour += hour;
                                //记录各班次排班对应请假详情
                                AttendLeave attendLeave = new AttendLeave();
                                attendLeave.setOaLeaveId(businessEntity.getId());
                                attendLeave.setLeaveDate(attendClockDto.getSchedulDate());
                                attendLeave.setSchedulDetailId(attendClockDto.getSchedulDetailId());
                                attendLeave.setLeaveHour(hour);
                                attendLeave.setLeaveType(businessEntity.getLeaveType());
                                attendLeave.setPerId(attendClockDto.getPerId());
                                attendLeave.setComId(attendClockDto.getComId());
                                attendLeave.setDeptId(attendClockDto.getDeptId());
                                attendLeave.setCreateTime(new Date());
                                attendLeave.setUpdateTime(new Date());
                                attendLeave.setIsDelete(Constants.N);
                                attendLeaveList.add(attendLeave);

                                // 迟到 扣除请假
                                if (lateMin > 0) {
                                    lateMin = calculateLateMinute(businessEntity, attendClockDto, lateMin, minute);
                                }
                                // 早退 扣除请假
                                if (leaveEarly > 0) {
                                    leaveEarly = calculateLeaveMinute(businessEntity, attendClockDto, leaveEarly, minute);
                                }
                                // 旷工 扣除请假
                                if (absenteeism > 0) {
                                    absenteeism = absenteeism - hour;
                                    absenteeism = absenteeism > 0 ? absenteeism : 0.0;
                                }
                                // 漏卡 扣除请假
                                if (missCard > 0) {
                                    if (StrUtil.isEmpty(attendClockDto.getClockEnd()) && businessEntity.getStopTime().getTime() >= DateUtils.parseDate(attendClockDto.getEndTime()).getTime()) {
                                        //请假结束时间大于等于下班时间 则不漏卡
                                        missCard = missCard - 1;
                                    }
                                    if (StrUtil.isEmpty(attendClockDto.getClockStart()) && businessEntity.getStartTime().getTime() <= DateUtils.parseDate(attendClockDto.getStartTime()).getTime()) {
                                        //请假开始时间小于等于上班时间 则不漏卡
                                        missCard = missCard - 1;
                                    }
                                }
                            }
                        }
                    }

                    if (leaveHour > attendClockDto.getShiftHour()) {
                        leaveHour = attendClockDto.getShiftHour();
                    }

                    /*公出*/
                    if (subReleaseList != null) {
                        for (PublicRelease businessEntity : subReleaseList) {
                            Double minute = calculateMinute(businessEntity, attendClockDto);
                            if (minute > 0) {
                                Double hour = BigDecimal.valueOf(minute / 60.0).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                                //businessEntity.setDiffTime(minute);
                                //businessList.add(businessEntity);
                                businessOut += hour;

                                // 迟到 扣除公出
                                if (lateMin > 0) {
                                    lateMin = calculateLateMinute(businessEntity, attendClockDto, lateMin, minute);
                                }
                                // 早退 扣除公出
                                if (leaveEarly > 0) {
                                    leaveEarly = calculateLeaveMinute(businessEntity, attendClockDto, leaveEarly, minute);
                                }
                                // 旷工 扣除公出
                                if (absenteeism > 0) {
                                    absenteeism = absenteeism - hour;
                                    absenteeism = absenteeism > 0 ? absenteeism : 0.0;
                                }
                                // 漏卡 扣除公出
                                if (missCard > 0) {
                                    if (StrUtil.isEmpty(attendClockDto.getClockEnd()) && businessEntity.getStopTime().getTime() >= DateUtils.parseDate(attendClockDto.getEndTime()).getTime()) {
                                        //公出结束时间大于等于下班时间 则不漏卡
                                        missCard = missCard - 1;
                                    }
                                    if (StrUtil.isEmpty(attendClockDto.getClockStart()) && businessEntity.getStartTime().getTime() <= DateUtils.parseDate(attendClockDto.getStartTime()).getTime()) {
                                        //公出开始时间小于等于上班时间 则不漏卡
                                        missCard = missCard - 1;
                                    }
                                }
                            }
                        }
                    }

                    if (businessOut > attendClockDto.getShiftHour()) {
                        businessOut = attendClockDto.getShiftHour();
                    }

                    /*出差*/
                    if (subTravelList != null) {
                        for (BusinessTravel businessEntity : subTravelList) {
                            Double minute = calculateMinute(businessEntity, attendClockDto);
                            if (minute > 0) {
                                Double hour = BigDecimal.valueOf(minute / 60.0).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                                //businessEntity.setDiffTime(minute);
                                //businessList.add(businessEntity);
                                businessTrip += hour;

                                // 迟到 扣除出差
                                if (lateMin > 0) {
                                    lateMin = calculateLateMinute(businessEntity, attendClockDto, lateMin, minute);
                                }
                                // 早退 扣除出差
                                if (leaveEarly > 0) {
                                    leaveEarly = calculateLeaveMinute(businessEntity, attendClockDto, leaveEarly, minute);
                                }
                                // 旷工 扣除出差
                                if (absenteeism > 0) {
                                    absenteeism = absenteeism - hour;
                                    absenteeism = absenteeism > 0 ? absenteeism : 0.0;
                                }
                                // 漏卡 扣除出差
                                if (missCard > 0) {
                                    if (StrUtil.isEmpty(attendClockDto.getClockEnd()) && businessEntity.getStopTime().getTime() >= DateUtils.parseDate(attendClockDto.getEndTime()).getTime()) {
                                        //出差结束时间大于等于下班时间 则不漏卡
                                        missCard = missCard - 1;
                                    }
                                    if (StrUtil.isEmpty(attendClockDto.getClockStart()) && businessEntity.getStartTime().getTime() <= DateUtils.parseDate(attendClockDto.getStartTime()).getTime()) {
                                        //出差开始时间小于等于上班时间 则不漏卡
                                        missCard = missCard - 1;
                                    }
                                }
                            }
                        }
                    }

                    if (businessTrip > attendClockDto.getShiftHour()) {
                        businessTrip = attendClockDto.getShiftHour();
                    }
                }

                //迟到
                if(!lateMin.equals(attendClockDto.getLateMin())){
                    updateFlag = true;
                }
                attendClockDto.setLateMin(lateMin);
                if(lateMin  > 0){
                    attendClockStatus = DictConst.CLOCKSTATUS_3;
                    //attendClockDto.setClockStatus(DictConst.CLOCKSTATUS_3);
                    if(StrUtil.isEmpty(attendClockDto.getClockEnd()) && DictConst.SHIFTTYPE_JSBC.equals(attendClockDto.getShiftType())){
                        attendClockStatus = DictConst.CLOCKSTATUS_23;
                        //attendClockDto.setClockStatus(DictConst.CLOCKSTATUS_23);
                    }
                }
                //早退
                if(!leaveEarly.equals(attendClockDto.getLeaveEarly())){
                    updateFlag = true;
                }
                attendClockDto.setLeaveEarly(leaveEarly);
                if(leaveEarly > 0){
                    attendClockStatus = DictConst.CLOCKSTATUS_4;
                    //attendClockDto.setClockStatus(DictConst.CLOCKSTATUS_4);
                    if(StrUtil.isEmpty(attendClockDto.getClockStart())){
                        attendClockStatus = DictConst.CLOCKSTATUS_24;
                        //attendClockDto.setClockStatus(DictConst.CLOCKSTATUS_24);
                    }
                }

                //迟到早退
                if(lateMin  > 0 && leaveEarly > 0){
                    attendClockStatus = DictConst.CLOCKSTATUS_34;
                    //attendClockDto.setClockStatus(DictConst.CLOCKSTATUS_34);
                }

                if(!absenteeism.equals(attendClockDto.getAbsenteeism())){
                    updateFlag = true;
                }
                attendClockDto.setAbsenteeism(absenteeism);
                //旷工时数
                if(absenteeism > 0){
                    if(!DictConst.CLOCKSTATUS_5.equals(attendClockDto.getClockStatus())) {
                        updateFlag = true;
                        attendClockStatus = DictConst.CLOCKSTATUS_5;
                        //attendClockDto.setClockStatus(DictConst.CLOCKSTATUS_5);
                    }
                }
                if(!missCard.equals(attendClockDto.getMissCard())){
                    updateFlag = true;
                    attendClockDto.setMissCard(missCard);
                }
                //漏卡
                if(missCard > 0) {

                }else{
                    //实际出勤时数(基数)= 班次时长
                    workHour = attendClockDto.getShiftHour();
                }

                //实际出勤时数 = 基数 + 公出 + 出差 - 早退 - 迟到 - 旷工 - 请假
                workHour += businessOut + businessTrip - leaveEarly/60.0 - lateMin/60.0 - absenteeism - leaveHour;

                workHour = BigDecimal.valueOf(workHour).setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
                if(workHour < 0){
                    workHour = 0.0D;
                }
                if(workHour > attendClockDto.getShiftHour()){
                    workHour = attendClockDto.getShiftHour();
                }
                if(leaveHour > attendClockDto.getShiftHour()){
                    leaveHour = attendClockDto.getShiftHour();
                }
                if(businessOut > attendClockDto.getShiftHour()){
                    businessOut = attendClockDto.getShiftHour();
                }
                if(businessTrip > attendClockDto.getShiftHour()){
                    businessTrip = attendClockDto.getShiftHour();
                }

                if(!workHour.equals(attendClockDto.getWorkHour())){
                    updateFlag = true;
                }
                attendClockDto.setWorkHour(workHour);
                //请假
                if(!leaveHour.equals(attendClockDto.getLeaveHour())){
                    attendClockDto.setLeaveHour(leaveHour);
                    updateFlag = true;
                }
                //公出
                if(!businessOut.equals(attendClockDto.getBusinessOut())){
                    updateFlag = true;
                    attendClockDto.setBusinessOut(businessOut);
                }
                //出差
                if(!businessTrip.equals(attendClockDto.getBusinessTrip())){
                    updateFlag = true;
                    attendClockDto.setBusinessTrip(businessTrip);
                }
                attendClockDto.setUpdateTime(DateUtils.getNowDate());

                if(!attendClockStatus.equals(attendClockDto.getClockStatus())){
                    updateFlag = true;
                    attendClockDto.setClockStatus(attendClockStatus);
                    if(lateMin<=0 && leaveEarly<=0 && absenteeism<=0 && missCard<=0){
                        attendClockDto.setClockStatus(DictConst.CLOCKSTATUS_1);
                    }
                }

                if(DictConst.SHIFTTYPE_JCBC.equals(attendClockDto.getShiftType())){
                    attendClockDto.setWorkHour(null);
                }

                if(updateFlag) {
                    clockList.add(attendClockDto);
                }
            }
        }

        //根据数据数量情况，切分不同的大小
        int limit = 200;

        if(attendLeaveList.size() > 0){
            //计算拆分次数
            int count = new Double(Math.ceil(attendLeaveList.size() * 1.0 / limit)).intValue();
            //存放拆分数据
            List<AttendLeave> subList = null;
            //循环拆分次数 生成相应数据文件
            for (int i = 0; i < count; i++) {
                subList = attendLeaveList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                attendLeaveService.saveBatch(subList);
            }
        }

        if(clockList.size() > 0){
            //计算拆分次数
            int count = new Double(Math.ceil(clockList.size() * 1.0 / limit)).intValue();
            //存放拆分数据
            List<AttendClock> subList = null;
            //循环拆分次数 生成相应数据文件
            for (int i = 0; i < count; i++) {
                subList = clockList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                attendClockMapper.updateBatchStatus(subList);
            }
        }

        List<AttendReport> reportList = attendReportMapper.selectListForReport(tlkPerIds,schedulDate);
        for (AttendReport attendReport : reportList) {
            if(attendReport.getId() == null){
                attendReport.setCreateTime(new Date());
            }
            attendReport.setIsDelete(Constants.N);
            attendReport.setUpdateTime(new Date());
            if(attendReport.getLeaveEarly() > 0
                    || attendReport.getLateMin() > 0
                    || (attendReport.getAbsenteeism() != null &&  attendReport.getAbsenteeism() > 0)
                    || attendReport.getMissCard() > 0
            ){
                attendReport.setAttendResultStatus(DictConst.ATTENDRESULTSTATUS_0);
            }else{
                attendReport.setAttendResultStatus(DictConst.ATTENDRESULTSTATUS_1);
            }

            /*加班*/
            WorkOvertime workOvertime = overtimeMap.get(attendReport.getTlkPerId());
            if(workOvertime != null) {
                /** 加班时数 */
                attendReport.setOvertime(workOvertime.getDiffTime());
            }else{
                attendReport.setOvertime(0.0D);
            }
            if(attendReport.getWorkHour() != null) {
                attendReport.setWorkHour(BigDecimal.valueOf(attendReport.getWorkHour() + attendReport.getOvertime()).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue());
                if (attendReport.getWorkHour() > 0) {
                    attendReport.setWorkCount(1);
                }
            }
            if(attendReport.getWorkNum() != null){
                attendReport.setWorkCount(1);
            }
        }

        Map<String, AttendReport> perReportMap = reportList.stream().collect(Collectors.toMap(AttendReport::getTlkPerId, Function.identity()));

        //休息日加班统计
        overtimeList = workOvertimeMapper.selectListForRest(tlkPerIds, schedulDate);
        if(overtimeList.size() > 0){
            tlkPerIds = overtimeList.stream().map(WorkOvertime::getUserId).collect(Collectors.toList());
            List<PerOrgRelation> perList = perOrgRelationMapper.selectByTlkIds(tlkPerIds);
            if(perList.size() > 0) {
                PerOrgRelation perOrgRelation = null;
                AttendReport attendReport = null;
                Map<String,PerOrgRelation> perMap = perList.stream().collect(Collectors.toMap(PerOrgRelation::getTlkPerId, Function.identity()));
                for (WorkOvertime workOvertime : overtimeList) {
                    perOrgRelation = perMap.get(workOvertime.getUserId());
                    if(perOrgRelation == null){
                        continue;
                    }
                    attendReport = perReportMap.get(workOvertime.getUserId());
                    if (attendReport == null) {
                        attendReport = attendReportMapper.findByPerId(perOrgRelation.getPerId(),schedulDate);
                        if (attendReport == null) {
                            attendReport = new AttendReport();
                            attendReport.setPerId(perOrgRelation.getPerId());
                            attendReport.setDeptId(perOrgRelation.getOrgId());
                            attendReport.setReportDate(schedulDate);
                            attendReport.setAttendReportType(DictConst.ATTENDREPORTTYPE_DAY);
                            attendReport.setAttendResultStatus(DictConst.ATTENDRESULTSTATUS_1);
                            attendReport.setShiftHour(0.0D);
                            attendReport.setWorkCount(1);
                            //attendReport.setRestCount(0);
                            attendReport.setWorkHour(workOvertime.getDiffTime());
                            attendReport.setAbsenteeism(0.0D);
                            attendReport.setLeaveEarly(0);
                            attendReport.setLeaveEarlyCount(0);
                            attendReport.setLateMin(0);
                            attendReport.setLateCount(0);
                            attendReport.setMissCard(0);
                            attendReport.setLeaveHour(0.0D);
                            attendReport.setBusinessOut(0.0D);
                            attendReport.setBusinessTrip(0.0D);
                            attendReport.setCreateTime(new Date());
                            attendReport.setIsDelete(Constants.N);
                        }
                        attendReport.setUpdateTime(new Date());
                        attendReport.setOvertime(workOvertime.getDiffTime());
                        reportList.add(attendReport);
                    }
                }
            }
        }

        if(reportList.size() > 0){
            //计算拆分次数
            int count = new Double(Math.ceil(reportList.size() * 1.0 / limit)).intValue();
            //存放拆分数据
            List<AttendReport> subList = null;
            //循环拆分次数 生成相应数据文件
            for (int i = 0; i < count; i++) {
                subList = reportList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                attendReportMapper.saveBatch(subList);
            }
        }
    }

    /**
     * 生成月结果统计
     */
    public void createMonthReport(){
        createMonthReport(DateUtil.getLastMonth(),null);
    }

    /**
     * 生成月结果统计
     * @param month
     */
    public void createMonthReport(String month,Long perId){
        try {
            int days = DateUtil.getDaysOfMonth(DateUtils.parseDate(month,"yyyy-MM"));

            attendReportMapper.removeMonthReport(month,perId);
            attendReportMapper.createMonthReport(month,perId,days);
            //List<AttendReport> reportList = attendReportMapper.selectListForStatistics(null,month);
        } catch (ParseException e) {
            e.printStackTrace();
        }


    }

    public static void main(String[] args) throws ParseException {
        AttendReport attendReport = new AttendReport();
        String month = "2021-08";
        System.out.println(DateUtil.getDaysOfMonth(DateUtils.parseDate(month,"yyyy-MM")));
    }

    /**
     * 计算 请假/公出/出差 时间
     * @param businessBaseEntity
     * @param attendClockDto
     * @return
     */
    public Double calculateMinute(OaBusinessBaseEntity businessBaseEntity, AttendClockDto attendClockDto){
        Double result = 0.0D ;
        Date startTime = null;
        Date endTime = null;
        if (businessBaseEntity.getStartTime().getTime() <= DateUtils.parseDate(attendClockDto.getStartTime()).getTime()) {
            //开始时间早于或等于上班时间
            startTime = DateUtils.parseDate(attendClockDto.getStartTime());
        } else {
            //开始时间晚于上班时间
            startTime = businessBaseEntity.getStartTime();
        }

        if (businessBaseEntity.getStopTime().getTime() >= DateUtils.parseDate(attendClockDto.getEndTime()).getTime()) {
            //结束时间晚于或等于上班时间
            endTime = DateUtils.parseDate(attendClockDto.getEndTime());
        } else if (businessBaseEntity.getStopTime().getTime() < DateUtils.parseDate(attendClockDto.getEndTime()).getTime()) {
            //结束时间早于上班时间
            endTime = businessBaseEntity.getStopTime();
        }

        if(startTime.getTime() > endTime.getTime()){
            return result;
        }

        boolean needRest = false;
        Date restStart = null;
        Date restEnd = null;
        if(Constants.Y.equals(attendClockDto.getNeedRest())) {
            needRest = true;
            if (businessBaseEntity.getStartTime().getTime() <= DateUtils.parseDate(attendClockDto.getRestStart()).getTime()) {
                //请假开始时间早于或等于休息开始时间
                restStart = DateUtils.parseDate(attendClockDto.getRestStart());
            } else {
                //请假开始时间晚于休息开始时间
                restStart = businessBaseEntity.getStartTime();
            }

            if (businessBaseEntity.getStopTime().getTime() >= DateUtils.parseDate(attendClockDto.getRestEnd()).getTime()) {
                //请假结束时间晚于或等于休息结束时间
                restEnd = DateUtils.parseDate(attendClockDto.getRestEnd());
            } else if (businessBaseEntity.getStopTime().getTime() < DateUtils.parseDate(attendClockDto.getRestEnd()).getTime()) {
                //请假结束时间早于休息结束时间
                restEnd = businessBaseEntity.getStopTime();
            }
        }

        if (startTime != null && endTime != null) {
            Double restHour = 0.0D;
            if (needRest && restStart != null && restEnd != null) {
                restHour = DateUtils.minDiff(restStart, restEnd);
            }
            result = DateUtils.minDiff(startTime, endTime) - restHour;
        }

        return result;
    }


    /**
     * 计算 迟到时间
     * @param businessBaseEntity
     * @param attendClockDto
     * @return
     */
    public Integer calculateLateMinute(OaBusinessBaseEntity businessBaseEntity, AttendClockDto attendClockDto,Integer lateMin,Double minute){
        Date clockStart = DateUtils.parseDate(attendClockDto.getClockStart());
        Date startTime = DateUtils.parseDate(attendClockDto.getStartTime());
        if(clockStart.getTime() <= businessBaseEntity.getStartTime().getTime()){
            //打卡时间在请假/出差/公出时间之前 不变
        }else if(clockStart.getTime() >= businessBaseEntity.getStopTime().getTime()){
            //打卡时间在请假/出差/公出时间之后 迟到时间减去请假/出差/公出时间
            lateMin = lateMin - minute.intValue();
        }else if(clockStart.getTime() >= businessBaseEntity.getStartTime().getTime() && clockStart.getTime() < businessBaseEntity.getStopTime().getTime()) {
            //打卡时间在请假/出差/公出时间内
            if(businessBaseEntity.getStartTime().getTime() > startTime.getTime()) {
                startTime = businessBaseEntity.getStartTime();
            }
            Date endTime = clockStart;
            if (startTime.getTime() < endTime.getTime()) {
                Integer restMinu = 0;
                //与休息时间比对
                if (Constants.Y.equals(attendClockDto.getNeedRest())) {
                    Date restStart = DateUtils.parseDate(attendClockDto.getRestStart());
                    Date restEnd = DateUtils.parseDate(attendClockDto.getRestEnd());
                    if(startTime.getTime() >= restStart.getTime() && startTime.getTime() <= restEnd.getTime()){
                        startTime = restEnd;
                    }else if(endTime.getTime() >= restStart.getTime() && endTime.getTime() <= restEnd.getTime()){
                        endTime = restStart;
                    }else if(startTime.getTime() < restStart.getTime() && endTime.getTime() > restEnd.getTime()){
                        restMinu = DateUtils.minDiff(attendClockDto.getRestStart(), attendClockDto.getRestEnd()).intValue();
                    }
                }
                if(startTime.getTime() < endTime.getTime()) {
                    lateMin = lateMin - (DateUtils.minDiff(startTime, endTime).intValue() - restMinu);
                }
            }
        }

        return lateMin > 0 ? lateMin:0;
    }

    /**
     * 计算 早退时间
     * @param businessBaseEntity
     * @param attendClockDto
     * @return
     */
    public Integer calculateLeaveMinute(OaBusinessBaseEntity businessBaseEntity, AttendClockDto attendClockDto,Integer leaveEarly,Double minute){
        Date clockEnd = DateUtils.parseDate(attendClockDto.getClockEnd());
        Date endTime = DateUtils.parseDate(attendClockDto.getEndTime());
        if(clockEnd.getTime() >= businessBaseEntity.getStopTime().getTime()){
            //打卡时间在请假/出差/公出时间之前 早退到时间减去请假/出差/公出时间
            leaveEarly = leaveEarly - minute.intValue();
        }else if(clockEnd.getTime() >= businessBaseEntity.getStopTime().getTime()){
            //打卡时间在请假/出差/公出时间之后 不变
        }else if(clockEnd.getTime() >= businessBaseEntity.getStartTime().getTime() && clockEnd.getTime() < businessBaseEntity.getStopTime().getTime()) {
            //打卡时间在请假/出差/公出时间内
            Date startTime = clockEnd;
            if(businessBaseEntity.getStopTime().getTime()<endTime.getTime()){
                endTime = businessBaseEntity.getStopTime();
            }
            if (startTime.getTime() < endTime.getTime()) {
                Integer restMinu = 0;
                //与休息时间比对
                if (Constants.Y.equals(attendClockDto.getNeedRest())) {
                    Date restStart = DateUtils.parseDate(attendClockDto.getRestStart());
                    Date restEnd = DateUtils.parseDate(attendClockDto.getRestEnd());
                    if(startTime.getTime() >= restStart.getTime() && startTime.getTime() <= restEnd.getTime()){
                        startTime = restEnd;
                    }else if(endTime.getTime() >= restStart.getTime() && endTime.getTime() <= restEnd.getTime()){
                        endTime = restStart;
                    }else if(startTime.getTime() < restStart.getTime() && endTime.getTime() > restEnd.getTime()){
                        restMinu = DateUtils.minDiff(attendClockDto.getRestStart(), attendClockDto.getRestEnd()).intValue();
                    }
                }
                if(startTime.getTime() < endTime.getTime()) {
                    leaveEarly = leaveEarly - (DateUtils.minDiff(startTime, endTime).intValue() - restMinu);
                }
            }
        }

        return leaveEarly > 0 ? leaveEarly:0;
    }


    public void updateReportForOA(OaBusinessDto searchDto) {
        OaBusinessBaseEntity oaBusiness = null;
        /** 加班时数 */
        Double overtime = 0.0D;
        switch (searchDto.getDictType()){
            case DictConst.OA_DICTTYPE_0:
                oaBusiness = leaveApplicationMapper.findById(searchDto.getId());
                break;
            case DictConst.OA_DICTTYPE_1:
                oaBusiness = workOvertimeMapper.findById(searchDto.getId());
                overtime = oaBusiness.getDiffTime();
                break;
            case DictConst.OA_DICTTYPE_2:
                oaBusiness = publicReleaseMapper.findById(searchDto.getId());
                break;
            case DictConst.OA_DICTTYPE_3:
                oaBusiness =businessTravelMapper.findById(searchDto.getId());
                break;
            case DictConst.OA_DICTTYPE_4:
                oaBusiness =makeUpCardMapper.findById(searchDto.getId());
                break;
            default:
                break;
        }


        if(oaBusiness == null){
            return;
        }
        if(overtime > 0){
            PerOrgRelation perOrgRelation = perOrgRelationMapper.selectPerOrgRelationByTlkId(oaBusiness.getUserId());
            if(perOrgRelation == null){
                return;
            }
            //日结果
            AttendReport attendReport = attendReportMapper.findByPerId(perOrgRelation.getPerId(),DateUtils.formatDate(oaBusiness.getStartTime(), DateUtils.YYYY_MM_DD));
            if(attendReport == null) {
                attendReport = new AttendReport();
                attendReport.setPerId(perOrgRelation.getPerId());
                attendReport.setDeptId(perOrgRelation.getOrgId());
                attendReport.setReportDate(DateUtils.formatDate(oaBusiness.getStartTime(), DateUtils.YYYY_MM_DD));
                attendReport.setAttendReportType(DictConst.ATTENDREPORTTYPE_DAY);
                attendReport.setAttendResultStatus(DictConst.ATTENDRESULTSTATUS_1);
                attendReport.setShiftHour(0.0D);
                attendReport.setWorkCount(1);
                attendReport.setWorkHour(oaBusiness.getDiffTime());
                attendReport.setAbsenteeism(0.0D);
                attendReport.setLeaveEarly(0);
                attendReport.setLeaveEarlyCount(0);
                attendReport.setLateMin(0);
                attendReport.setLateCount(0);
                attendReport.setMissCard(0);
                attendReport.setLeaveHour(0.0D);
                attendReport.setBusinessOut(0.0D);
                attendReport.setOvertime(oaBusiness.getDiffTime());
                attendReport.setBusinessTrip(0.0D);
                attendReport.setCreateTime(new Date());
                attendReport.setUpdateTime(new Date());
                attendReport.setIsDelete(Constants.N);
                attendReportMapper.save(attendReport);
            }else{
                attendReport.setWorkHour(attendReport.getWorkHour() + oaBusiness.getDiffTime());
                attendReport.setOvertime(attendReport.getOvertime() + oaBusiness.getDiffTime());
                attendReport.setUpdateTime(new Date());
                attendReportMapper.updateSelective(attendReport);
            }
            //月结果
            attendReport = attendReportMapper.findByPerId(perOrgRelation.getPerId(),DateUtils.formatDate(oaBusiness.getStartTime(), DateUtils.YYYY_MM));
            if(attendReport != null){
                attendReport.setWorkHour(attendReport.getWorkHour() + oaBusiness.getDiffTime());
                attendReport.setOvertime(attendReport.getOvertime() + oaBusiness.getDiffTime());
                attendReport.setUpdateTime(new Date());
                attendReportMapper.updateSelective(attendReport);
            }
            return;
        }

        if(DictConst.OA_DICTTYPE_4.equals(searchDto.getDictType())){
            AttendClockDto attendClockDto = attendClockMapper.findByOABusiness((MakeUpCard)oaBusiness);
            if(attendClockDto == null){
                return;
            }
            if(DictConst.CLOCKTYPE_SB.equals(((MakeUpCard)oaBusiness).getCardType())){
                attendClockDto.setClockStart(DateUtils.formatDate(oaBusiness.getStartTime(),DateUtils.YYYY_MM_DD_HH_MM));
            }else{
                attendClockDto.setClockEnd(DateUtils.formatDate(oaBusiness.getStartTime(),DateUtils.YYYY_MM_DD_HH_MM));
            }
            attendClockDto.setUpdateBy(searchDto.getUpdateBy());
            attendClockDto.setUpdateTime(DateUtils.getNowDate());
            List<AttendClock> clockList = new ArrayList<>();
            clockList.add(attendClockDto);
            attendClockMapper.updateBatchStatus(clockList);
            attendClockMapper.updateClockStatusForPer(attendClockDto.getPerId(),attendClockDto.getSchedulDate());
            createDayReport(attendClockDto.getSchedulDate(),false,attendClockDto.getPerId());
        }else{
            PerBaseInfo perBaseInfo = perBaseInfoMapper.selectPerBaseInfoByTlkId(oaBusiness.getUserId());
            if(perBaseInfo == null){
                return;
            }
            List<Date> dates = DateUtil.getBetweenDates(oaBusiness.getStartTime(), oaBusiness.getStopTime());
            for (Date date : dates) {
                createDayReport(DateUtils.formatDate(date, DateUtils.YYYY_MM_DD), false, perBaseInfo.getPerId());
            }
        }

        attendReportMapper.updateMonthReportForOA(oaBusiness);
    }

}
