package com.bcxin.platform.mapper.wallet;

import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.dto.wallet.ComWalletAccountDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业钱包账户
 *
 * @author llc
 * @date 2019-06-21
 */
public interface ComWalletAccountMapper {


    /**
     * 插入企业钱包账户
     *
     * @param comWalletAccount
     * @return
     * @author llc
     * @date 2019-06-22
     */
    int insertComWalletAccount(ComWalletAccount comWalletAccount);
    /**
     * <b> 修改企业钱包账户 </b>
     * @author ZXF
     * @create 2023/04/12 0012 11:17
     * @version
     * @注意事项 </b>
     */
    int updateComWalletAccountAll(ComWalletAccount comWalletAccount);


    /**
     * 更新企业钱包账户
     *
     * @param comWalletAccount
     * @return
     * @author llc
     * @date 2019-06-22
     */
    int updateComWalletAccount(ComWalletAccount comWalletAccount);

    int updateComWalletAccountNo(ComWalletAccount comWalletAccount);


    /**
     * 查询所有企业钱包账户
     *
     * @return
     */
    List<ComWalletAccountDTO> getAllComWalletAccount();

    /**
     * 查询企业钱包账户
     *
     * @param comId
     * @return
     * @author llc
     * @date 2019-06-24
     */
    ComWalletAccountDTO getComWalletAccountByComId(@Param("comId") Long comId);

    /**
     * <b> 修改冻结金额 </b>
     * @author ZXF
     * @create 2023/03/30 0030 16:36
     * @version
     * @注意事项 </b>
     */
    void updateFrozenAmount(@Param("comId") Long comId, @Param("frozenAmount") String frozenAmount);


    /**
     * 查询企业钱包账户(天翎)
     *
     * @param tlkComId
     * @return
     * @author huzh
     * @date 2021-04-09
     */
    ComWalletAccountDTO getComWalletAccountByTLKComId(@Param("tlkComId") String tlkComId);


    /**
     * 根据钱包号查询企业钱包账户
     *
     * @param walletNo
     * @return
     * @author lp
     * @date 2019-09-03
     */
    ComWalletAccountDTO getComWalletAccountByWalletNo(@Param("walletNo") String walletNo);

    /**
     * 根据钱包号或者财智卡号（工行）查询企业钱包账户
     *
     * @param walletNo
     * @return
     * @author lp
     * @date 2019-09-03
     */
    ComWalletAccountDTO getComWalletAccountByWalletNoORCardnoGS(@Param("walletNo") String walletNo);

    /**
     * <b> 根据结算卡号查询保证金账号 </b>
     * @author ZXF
     * @create 2023/02/20 0020 17:03
     * @version
     * @注意事项 </b>
     */
    String getWalletAccountNoBybankCardNo(@Param("bankCardNo") String bankCardNo);

    /**
     * 根据所有查询企业钱包和个人账户名称
     *
     * @return
     */
    List<Map<String, String>> getAllAccountName();

}