package com.bcxin.platform.dto.meeting;

import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <b> 预约会议请求报文字段 </b>
 *
 * @author ZXF
 * @create 2020/01/13 0013 14:35
 * @注意事项 </b>
 */
@Data
public class RestScheduleConfDTO extends PerHuaweiMeetMatch {

    /**
     * 会议类型：0 : 普通会议，1：周期会议，此时“cycleParams”必须填写
     */
    @ApiModelProperty(value = "会议类型")
    private Integer conferenceType = 0;

    /**
     * 会议开始时间，格式：YYYY-MM-DD HH:MM。创建预约会议时，如果没有指定开始时间或填空串，则表示会议马上开始。
     */
    @ApiModelProperty(value = "会议开始时间")
    private String startTime;

    /**
     * 会议持续时长 单位分钟，最大值为1440，最短15
     */
    @ApiModelProperty(value = "会议持续时长")
    private Integer length = 30;

    /**
     * 会议主题
     */
    @ApiModelProperty(value = "会议主题")
    private String subject;

    /**
     * 会议的媒体类型，多个逗号分隔："Voice”：语音，"Video”：标清视频，"HDVideo”：高清视频，"Telepresence”：智真，"Data”：多媒体
     * 必填
     */
    @ApiModelProperty(value = "会议的媒体类型")
    private String mediaTypes;


    /**
     * 群组ID
     */
    @ApiModelProperty(value = "群组ID")
    private String groupuri;

    /**
     * 入会欢迎词开关，0: 不提示，1: 提示音
     */
    @ApiModelProperty(value = "入会欢迎词开关")
    private Integer welcomeVoiceEnable = 0;

    /**
     * 有成员入会提示音开关,-1： 无提示音,-2： 默认提示音,-3： 提示音（DU）
     */
    @ApiModelProperty(value = "有成员入会提示音开关")
    private Integer enterPrompt = -1;
    /**
     * 有成员离会提示音开关，同上
     */
    @ApiModelProperty(value = "有成员离会提示音开关")
    private Integer leavePrompt = -1;
    /**
     * 与会者列表
     */
    @ApiModelProperty(value = "与会者列表")
    private List<AttendeeDTO> attendees;

    private String attendeesJSON;
    /**
     * 会议是否自动启动录制,1：自动启动录制,0：不自动启动录制
     */
    @ApiModelProperty(value = "会议是否自动启动录制")
    private Integer isAutoRecord = 0;
    /**
     * 会议媒体加密模式,0：自适应加密,1 : 强制加密,2 : 不加密
     */
    @ApiModelProperty(value = "会议媒体加密模式")
    private Integer encryptMode = 0;
    /**
     * 会议的默认语言,zh-CN：简体中文,en-US：美国英文
     */
    @ApiModelProperty(value = "会议的默认语言")
    private String language = "zh-CN";
    /**
     * 标识是否为多流视频会议,0：单流会议,1：多流会议
     */
    @ApiModelProperty(value = "标识是否为多流视频会议")
    private Integer multiStreamFlag = 0;
    /**
     * 开始时间的时区信息,默认北京时区
     */
    @ApiModelProperty(value = "开始时间的时区信息")
    private String timeZoneID = "56";
    /**
     * 录播类型，0: 禁用，1: 直播，2: 录播，3: 直播+录播
     */
    @ApiModelProperty(value = "录播类型")
    private Integer recordType = 0;
    /**
     * 直播推流频道ID
     */
    @ApiModelProperty(value = "直播推流频道ID")
    private String liveChannelID;
    /**
     * 主流直播地址
     */
    @ApiModelProperty(value = "主流直播地址")
    private String liveAddress;
    /**
     * 辅流直播地址
     */
    @ApiModelProperty(value = "辅流直播地址")
    private String auxAddress;
    /**
     * 是否录制辅流,0：否,1：是
     */
    @ApiModelProperty(value = "是否录制辅流")
    private Integer recordAuxStream = 0;
    /**
     * 会议其他配置信息
     */
    @ApiModelProperty(value = "会议其他配置信息")
    private ConfConfigInfoDTO confConfigInfo = new ConfConfigInfoDTO();
    /**
     * 录播鉴权方式,0：老的鉴权方式，url中携带token鉴权,1：企业内会议用户鉴权,2：会议内会议用户鉴权
     */
    @ApiModelProperty(value = "录播鉴权方式")
    private Integer recordAuthType;
    /**
     * 是否使用VMR召开预约会议,0：不使用VMR,1：使用个人VMR
     */
    @ApiModelProperty(value = "是否使用VMR召开预约会议")
    private Integer vmrFlag;
    /**
     * 用于识别用户开会时绑定的VMR会议室
     */
    @ApiModelProperty(value = "用于识别用户开会时绑定的VMR会议室")
    private String vmrID;
}
