package com.bcxin.platform.domain.meeting;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 人员华为云会议映射
 *
 * @author llc
 * @date 2019-12-10
 */
@TableName("per_huawei_meet_match")
@DisMultiTenancy
@Data
public class PerHuaweiMeetMatch extends BaseEntity<PerHuaweiMeetMatch> {

    /**
     * 人员ID
     */
    @ApiModelProperty(value = "人员ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;


    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用")
    private String isActive;

    /**
     * 华为云会议用户名
     */
    @ApiModelProperty(value = "华为云会议用户名")
    private String huaweiUserName;

    /**
     * 华为云会议密码
     */
    @ApiModelProperty(value = "华为云会议密码")
    private String huaweiPassWord;

    /**
     * 华为云会议用户ID
     */
    @ApiModelProperty(value = "华为云会议用户ID")
    private String huaweiUserId;

    /**
     * 华为云用户SIP号码
     */
    @ApiModelProperty(value = "华为云用户SIP号码")
    private String huaweiSipName;

    /**
     * 监管会议负责人类型
     */
    @ApiModelProperty(value = "监管会议负责人类型")
    private String regulatorMeetChargeType;

}