package com.bcxin.oaflow.mapper;

import com.bcxin.oaflow.domain.BusinessTravel;
import com.bcxin.oaflow.dto.OaBusinessDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 出差Mapper接口
 * 
 * @author lin
 * @date 2021-09-01
 */
public interface BusinessTravelMapper{

    /**
     * 查询出差
     * 
     * @param id 出差ID
     * @return 出差
     */
    BusinessTravel findById(String id);

    /**
     * 查询出差列表
     * 
     * @param tlkPerIds
     * @param schedulDate
     * @return 出差集合
     */
    List<BusinessTravel> selectList(@Param("list")List<String> tlkPerIds,@Param("schedulDate")String schedulDate);

    /**
     * 查询出差列表
     *
     * @param tlkPerId
     * @param schedulDate
     * @return 出差集合
     */
    List<OaBusinessDto> findByUserId(@Param("tlkPerId")String tlkPerId, @Param("schedulDate")String schedulDate);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<BusinessTravel> findByBatchId(@Param("list") List<BusinessTravel> list);

}
