/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import io.netty.util.internal.StringUtil;
import java.util.Base64;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class LocationMessageContent
extends MessageContent {
    private String title;
    public byte[] thumbnailByte;
    private double longitude;
    private double latitude;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public byte[] getThumbnailByte() {
        return this.thumbnailByte;
    }

    public void setThumbnailByte(byte[] thumbnailByte) {
        this.thumbnailByte = thumbnailByte;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    @Override
    public int getContentType() {
        return 4;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setSearchableContent(this.title);
        payload.setBase64edData(Base64.getEncoder().encodeToString(this.thumbnailByte));
        JSONObject objWrite = new JSONObject();
        objWrite.put((Object)"lat", (Object)this.latitude);
        objWrite.put((Object)"long", (Object)this.longitude);
        payload.setContent(objWrite.toString());
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        if (!StringUtil.isNullOrEmpty((String)payload.getBase64edData())) {
            this.thumbnailByte = Base64.getDecoder().decode(payload.getBase64edData());
        }
        this.title = payload.getSearchableContent();
        try {
            if (payload.getContent() != null) {
                JSONObject jsonObject = (JSONObject)new JSONParser().parse(payload.getContent());
                this.latitude = (Double)jsonObject.get((Object)"lat");
                this.longitude = (Double)jsonObject.get((Object)"long");
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

