import vue from "@vitejs/plugin-vue";
import { resolve } from "path";
import { defineConfig, loadEnv, ConfigEnv } from "vite";
import VueSetupExtend from "vite-plugin-vue-setup-extend";//setup语法糖增加name
const pathResolve = (dir: string): any => {
  return resolve(__dirname, '.', dir)
}
const alias: Record<string, string> = {
  '/@': pathResolve('./src/')
}
// https://vitejs.dev/config/
const viteConfig = defineConfig((mode: ConfigEnv) => {
  const env = loadEnv(mode.mode, process.cwd())
  return {
    plugins: [vue(), VueSetupExtend()],
    root: process.cwd(),//此方法返回一个字符串，该字符串指定node.js进程的'当前工作目录'
    resolve: {
      alias
    },
    base: mode.command === 'serve' ? './' : env.VITE_PUBLIC_PATH,
    server: {
      host: "0.0.0.0",
      port: env.VITE_PORT as unknown as number,
      open: false,
      hmr: { overlay: false },
      proxy: {
        '/dispatch': {
          target: 'https://v5qy.te.baibaodun.com.cn',
          // target: 'https://v5qy.baibaodun.cn',
          ws: true,
          changeOrigin: true,
          pathRewrite: {
            '^/dispatch': '/dispatch'
          },
          // rewrite: (path) => path.replace(/^\/dispatch/, ''),
        },
        '/sync': {
          target: 'https://v5qy.te.baibaodun.com.cn',
          // target: 'https://v5qy.baibaodun.cn',
          ws: true,
          changeOrigin: true,
          pathRewrite: {
            '^/sync': '/sync'
          },
          // rewrite: (path) => path.replace(/^\/dispatch/, ''),
        },
      }
    },
    define: {
      __VUE_I18N_LEGACY_API__: JSON.stringify(false),
      __VUE_I18N_FULL_INSTALL__: JSON.stringify(false),
      __INTLIFY_PROD_DEVTOOLS__: JSON.stringify(false),
      __VERSION__: JSON.stringify(process.env.npm_package_version),//process.env.npm_package_version配置文件-->获取package.json包里面的version版本字段
    },
  };
});
export default viteConfig;