/// <reference types="vite/client" />

// 声明文件，*.vue 后缀的文件交给 vue 模块来处理
declare module '*.vue' {
  import type { DefineComponent } from 'vue'
  const component: DefineComponent<{}, {}, any>
  export default component
}

//全局声明 该控件类型
declare module 'js-cookie';

// 声明文件，定义全局变量。其它 app.config.globalProperties.xxx，使用 getCurrentInstance() 来获取
//在 src 目录下，会多一个 vite-env.d.ts 文件，进行声明，会自动把类型添加到 vite 提供的 import.meta.env 上
interface Window {
  nextLoading: Boolean;
}
