import axios, { AxiosInstance, AxiosRequestConfig } from 'axios';
import { ElMessage, ElMessageBox } from 'element-plus';
import { Session, Local } from '/@/utils/storage';
import qs from 'qs';

// 配置新建一个 axios 实例
const service: AxiosInstance = axios.create({
	// baseURL: import.meta.env.VITE_API_URL,
	timeout: 50000,
	headers: { 'Content-Type': 'application/json' },
	paramsSerializer: {
		serialize(params) {
			// debugger
			return qs.stringify(params, { allowDots: true });
		},
	},
});

// 添加请求拦截器
service.interceptors.request.use(
	(config: AxiosRequestConfig) => {
		// 在发送请求之前做些什么 token	
		let deskTypes = Session.get('platform')==='2' ? ['Proprietor'] : Session.get('platform')==='3' ? ["TemporarySecurity"] : ['Normal']
		let accessToken = localStorage.getItem('accessToken') || ''
		let dispatchToken = localStorage.getItem('dispatchToken') || ''
		console.log('dispatchToken', dispatchToken)
		if (Session.get('token')) {
			config.headers!['Authorization'] = `${Session.get('token')}` || '';
			config.headers!['accessToken'] = accessToken;
			config.headers!['dispatchToken'] = dispatchToken || '';
			// config.headers!['accountType'] = 'Desk';//"accountType":"APP",//防控指挥账号类型：百保盾APP，第三方设备Device，调度台客户端Desk	
		}
		config.data = {
			...config.data,
			deskTypes: deskTypes,
		}
		return config;
	},
	(error) => {
		// 对请求错误做些什么
		return Promise.reject(error);
	}
);

// 添加响应拦截器
service.interceptors.response.use(
	(response) => {
		// 对响应数据做点什么
		console.log('response22', response)
		const res = response.data;
		if (res.code && res.code !== 0 && response.config.url !== "/sync/api/device/record/list") {
			// `token` 过期或者账号已在别处登录
			// if (res.code === 401 || res.code === 4001) {
			// 	Session.clear(); // 清除浏览器全部临时缓存
			// 	window.location.href = '/'; // 去登录页
			// 	ElMessageBox.alert('你已被登出，请重新登录', '提示', {})
			// 		.then(() => { })
			// 		.catch(() => { });
			// }
			return Promise.reject(service.interceptors.response);
		} else {
			return response.data;
		}
	},
	(error) => {
		console.log('error', error)
		if (error && (error.response) && (error.response.status)) {//405表示 not allowed
			// ElMessage.error(error.response.data.message)
			if(error.response.status==401){
				ElMessage.error('登录已过期,请退出浏览器重新登录')
			}else if(error.response.status==403){
				ElMessage.error(error.response.data.message||'请联系管理员')
			}else{
			  ElMessage.error('请联系管理员!')
			}
			return Promise.resolve(error.response.data)
		}
		// 对响应错误做点什么
		if (error.message.indexOf('timeout') != -1) {
			ElMessage.error('网络超时');
		} else if (error.message == 'Network Error') {
			ElMessage.error('网络连接错误');
		} else {
			if (error.response && error.response.data) ElMessage.error(error.response.statusText);
			else ElMessage.error('接口路径找不到');
		}
		return Promise.reject(error);
	}
);

// 导出 axios 实例
export default service;
