/**
 * 获取日期时间组件的开始和结束时间
 * @param dayRange 传入的天数
 * @returns {{start, end}}
 */
export function getStartEndOfDayTime(dayRange: number): { start: string; end: string } {
	var tempDate = new Date() // 获取今天的日期
	var hour: any = tempDate.getHours()//时
	var minutes: any = tempDate.getMinutes()//分
	var seconds: any = tempDate.getSeconds()//秒
	if (hour >= 0 && hour <= 9) {
		hour = "0" + hour;
	}
	if (minutes >= 0 && minutes <= 9) {
		minutes = "0" + minutes;
	}
	if (seconds >= 0 && seconds <= 9) {
		seconds = "0" + seconds;
	}
	var hms = `${hour}:${minutes}:${seconds}`
	let end = tempDate.getFullYear() + '-' + (tempDate.getMonth() + 1 < 10 ? '0' + (tempDate.getMonth() + 1) : tempDate.getMonth() + 1) + '-' + (tempDate.getDate() < 10 ? '0' + tempDate.getDate() : tempDate.getDate()) + ' ' + hms
	tempDate.setDate(tempDate.getDate() - dayRange) // 今天的前N天的日期，N自定义
	var start = tempDate.getFullYear() + '-' + (tempDate.getMonth() + 1 < 10 ? '0' + (tempDate.getMonth() + 1) : tempDate.getMonth() + 1) + '-' + (tempDate.getDate() < 10 ? '0' + tempDate.getDate() : tempDate.getDate()) + ' 00:00:00'
	return {start, end};
}