import { ref } from 'vue'
import { RouteRecordRaw } from 'vue-router'

/**
 * 路由meta对象参数说明
 * meta: {
 *      title:          菜单栏及 tagsView 栏、菜单搜索名称（国际化）
 *      isLink：        是否超链接菜单，开启外链条件，`1、isLink: 链接地址不为空 2、isIframe:false`
 *      isHide：        是否隐藏此路由
 *      isKeepAlive：   是否缓存组件状态
 *      isAffix：       是否固定在 tagsView 栏上
 *      isIframe：      是否内嵌窗口，开启条件，`1、isIframe:true 2、isLink：链接地址不为空`
 *      roles：         当前路由权限标识，取角色管理。控制路由显示、隐藏。超级管理员：admin 普通角色：common
 *      icon：          菜单、tagsView 图标，阿里：加 `iconfont xxx`，fontawesome：加 `fa xxx`
 * }
 */

// 扩展 RouteMeta 接口
declare module 'vue-router' {
  interface RouteMeta {
    title?: string;
    isLink?: string;
    isHide?: boolean;
    isKeepAlive?: boolean;
    isAffix?: boolean;
    isIframe?: boolean;
    roles?: string[];
    icon?: string;
  }
}

/**
 * 定义静态路由（默认路由）
 */
export const staticRoutes: Array<RouteRecordRaw> = [
  {
    path: '/login',
    name: 'login',
    component: () => import('/@/views/login/index.vue'),
    meta: {
      title: '登录',
    }
  },
  {
    path: '/test',
    name: 'test',
    component: () => import('/@/views/test/index.vue'),
    meta: {
      title: '测试',
    }
  },
]
/**
 * 定义动态路由 
 */
export const dynamicRoutes: Array<RouteRecordRaw> = [
  {
    path: '/',
    name: '/',
    component: () => import('/@/layout/index.vue'),
    redirect: '/dispatchView/dispatchRecords',
    meta: {
      isKeepAlive: true,
      // title:'',
      // isLink:'',
      // isHide:false,
      // isKeepAlive:true,
      // isAffix:true,
      // isIframe:false,
      // roles:['admin','common'],
      // icon:'iconfont icon-shouye'
    },
    children: [
      {
        path: '/dispatchView/dispatchRecords',
        name: 'dispatchRecords',
        component: () => import('/@/views/dispatchView/dispatchRecords/index.vue'),
        meta: {
          title: '调度记录',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },

      {
        path: '/dispatchView/warnManage',
        name: 'warnManage',
        component: () => import('/@/views/dispatchView/warnManage/index.vue'),
        meta: {
          title: '线索管理',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },

      {
        path: '/dispatchView/signedManage',
        name: 'signedManage',
        component: () => import('/@/views/dispatchView/signedManage/index.vue'),
        meta: {
          title: '签到管理',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },

      {
        path: '/dispatchView/sosRecords',
        name: 'sosRecords',
        component: () => import('/@/views/dispatchView/sosRecords/index.vue'),
        meta: {
          title: 'sos记录',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },

      {
        path: '/dispatchView/railAlarm',
        name: 'railAlarm',
        component: () => import('/@/views/dispatchView/railAlarm/index.vue'),
        meta: {
          title: '围栏告警',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },

      {
        path: '/dispatchView/companyInfo',
        name: 'companyInfo',
        component: () => import('/@/views/dispatchView/companyInfo/index.vue'),
        meta: {
          title: '企业信息',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },
      {
        path: '/dispatchView/unactivatedSecurityGuard',
        name: 'unactivatedSecurityGuard',
        component: () => import('/@/views/dispatchView/unactivatedSecurityGuard/index.vue'),
        meta: {
          title: '未激活人员',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      },
      {
        path: '/dispatchView/videoRecordManagement',
        name: 'videoRecordManagement',
        component: () => import('/@/views/dispatchView/videoRecordManagement/index.vue'),
        meta: {
          title: '监控回放',
          isLink: '',
          isHide: false,
          isKeepAlive: true,
          isAffix: true,
          isIframe: false,
          roles: ['admin', 'common'],
          icon: 'iconfont icon-shouye'
        }
      }   
    ]
  },

]

/**
 * 定义404、401界面
 * @link 参考：https://next.router.vuejs.org/zh/guide/essentials/history-mode.html#netlify
 */
export const notFoundAndNoPower = [
  {
    path: '/:path(.*)*',
    name: 'notFound',
    component: () => import('/@/views/error/404.vue'),
    meta: {
      title: 'message.staticRoutes.notFound',
      isHide: true
    }
  },
  {
    path: '/401',
    name: 'noPower',
    component: () => import('/@/views/error/401.vue'),
    meta: {
      title: 'message.staticRoutes.noPower',
      isHide: true
    }
  }
]