import { createApp } from 'vue';
import pinia from '/@/stores/index';
import App from './App.vue';
import router from './router';
import { directive } from '/@/directive/index';
import { i18n } from '/@/i18n/index';
import other from '/@/utils/other';

import ElementPlus from 'element-plus';
import 'element-plus/dist/index.css';
import '/@/theme/index.scss';
import VueGridLayout from 'vue-grid-layout';

import JsonViewer from "vue3-json-viewer"//json预览
import "vue3-json-viewer/dist/index.css";
// import {loadEnv} from 'vite'
// const env=loadEnv('development',process.cwd())
// console.log(env)
// console.log(process.env.NODE_ENV)
import vue3PreviewImage from 'vue3-preview-image'

const app = createApp(App);

directive(app);
other.elSvg(app);

app.use(pinia).use(router).use(vue3PreviewImage).use(ElementPlus, { i18n: i18n.global.t }).use(i18n).use(VueGridLayout).use(JsonViewer).mount('#app');
