import request from '/@/utils/request'

/**
 * 后端控制菜单模拟json，路径在 https://gitee.com/lyt-top/vue-next-admin-images/tree/master/menu
 * 后端控制路由，isRequestRoutes 为 true，则开启后端控制路由
 * @method getMenuAdmin 获取后端动态路由菜单(admin)
 * @method getMenuTest 获取后端动态路由菜单(test)
 */
export function ConfigApi() {
  return {
    getTaskTypeList: (data?: object) => { //获取任务类型
      return request({
        url: `/obpm/magic-api/duty/task/type/list`,
        method: 'post',
        data,
      })
    },

    createTaskDetail: (data?: object) => { //新建任务
      return request({
        url: `/obpm/magic-api/duty/task/create`,
        method: 'post',
        data,
      })
    },

    securityArrange: (data?: object) => { //添加保安员
      return request({
        url: `/obpm/magic-api/duty/task/security/arrange`,
        method: 'post',
        data,
      })
    },

    noticeArrange: (data?: object) => { //消息通知，任务指派
      return request({
        url: `/obpm/magic-api/duty/task/notice/arrange`,
        method: 'post',
        data,
      })
    },

    dispatchidentityLoginApi: (data?: object) => {//单点登入调度系统
      return request({
        url: `/dispatch/identity/Desk/auto-login`,//"accountType":"APP",//防控指挥账号类型：百保盾APP，第三方设备Device，调度台客户端Desk
        method: 'post',
        data,
      })
    },

    searchDepartsApi: (data?: object) => { //查询监管机构
      return request({
        url: `/dispatch/departs/searchDeparts`,
        method: 'post',
        data,
      })
    },

    eventMetaDataApi: (data?: object) => {//查询事件类别与事件类型元数据
      return request({
        url: `/dispatch/json/policeIncident-meta.json`,
        method: 'get',
        data,
      })
    },

    policeIncidentsSearchApi: (data?: object) => {//警情上报查询
      return request({
        url: `/dispatch/policeIncidents/search`,
        method: 'post',
        data,
      })
    },

    policeIncidentsEditApi: (data?: object) => {//警情上报处理
      return request({
        url: `/dispatch/policeIncidents`,
        method: 'put',
        data,
      })
    },

    policeIncidentsDeleteApi: (id: String) => {//警情删除
      return request({
        url: `/dispatch/policeIncidents/${id}`,
        method: 'delete',
      })
    },

    attendanceSearchApi: (data?: object) => {//签到查询
      return request({
        url: `/dispatch/attendance/search-group`,
        method: 'post',
        data,
      })
    },

    attendanceDetailApi: (data?: object,obj2?:object) => {//签到签退明细
      return request({
        url: `/dispatch/attendance/search-group/${data.employeeId}`,
        method: 'post',
        data:obj2,
      })
    },

    attendancesearchDayApi: (data?: object) => {//签到签退详情
      return request({
        url: `/dispatch/attendance/searchDay`,
        method: 'post',
        data,
      })
    },

    dispatchlogsApi: (data?: object) => {//调度记录
      return request({
        url: `/dispatch/dispatch-logs`,
        method: 'post',
        data,
      })
    },

    dispatchlogsyDetailApi: (data?: object) => {//调度详情
      return request({
        url: `/dispatch/dispatch-logs/${data.id}/detail-logs/${data.calledOrganizationId}`,
        method: 'post',
        data,
      })
    },

    railAlarmSearchApi: (data?: object) => {//围栏告警查询
      return request({
        url: `/dispatch/security-station-rail-messages/search`,
        method: 'post',
        data,
      })
    },
    
    companyInfoSearchApi: (data?: object) => { // 企业信息列表查询
      return request({
        url: `/dispatch/companies/advance-search`,
        method: 'post',
        data
      });
    },

    exportCompanyInfoApi: (data?: object) => { // 企业信息列表列表--导出
      return request({
        url: `/dispatch/companies/export`,
        method: 'post',
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      });
    },

    unActivatedSecurityGuardSearchApi: (data?: object) => { // 查询对应企业未激活保安员列表
      return request({
        url: `/dispatch/employees/advance-search`,
        method: 'post',
        data
      });
    },

    exportunActivatedSecurityApi: (data?: object) => { // 企业未激活保安员列表--导出
      return request({
        url: `/dispatch/employees/export`,
        method: 'post',
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      });
    },

    exportDispatchLogApi: (data?: object) => {// 调度记录--导出
      return request({
        url: `/dispatch/dispatch-logs/export`,
        method: 'post',
        // params:data,//get请求url携带参数写法params
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      })
    },

    exportWarnManageApi: (data?: object) => {// 警情上报--导出
      return request({
        url: `/dispatch/policeIncidents/export`,
        method: 'post',
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      })
    },

    exportsignedManageApi: (data?: object) => {// 签到管理--导出
      return request({
        url: `/dispatch/attendance/export`,
        method: 'post',
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      })
    },

    exportDetailsignedManageApi: (data?: object) => {// 签到管理--导出明细
      return request({
        url: `/dispatch/attendance/export-detail`,
        method: 'post',
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      })
    },

    exportSosRecordsApi: (data?: object) => {// sos记录--导出
      return request({
        url: `/dispatch/policeIncidents/export`,
        method: 'post',
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      })
    },

    exportRailMessageApi: (data?: object) => {// 围栏告警--导出
      return request({
        url: `/dispatch/security-station-rail-messages/export`,
        method: 'post',
        data,
        responseType: 'blob',//导出EXCEL必须配置--返回类型模式blob流
      })
    },

    videoRecordSearchApi: (data?: object) => { // 查询对应企业未激活保安员列表
      return request({
        url: `/sync/api/device/record/list`,
        method: 'post',
        data
      });
    },

    // sourcesinkjdbcApi: (params?: object) => {//查询jdbc可用项
    //   return request({
    //     url: `/job-web/source-sink/jdbc`,
    //     method: 'get',
    //     params,
    //   })
    // },
    // jobmetasApi: (data?: object) => {//新增数据归集项配置
    //   return request({
    //     url: `/job-web/job-metas/simple`,
    //     method: 'post',
    //     data,
    //   })
    // },
    // topiclistApi: (data?: object) => {//查询订阅主题
    //   return request({
    //     url: `/job-web/source-sink/kafka`,
    //     method: 'get',
    //     data,
    //   })
    // },
    // jobmetassearchApi: (data?: object) => {//查询所有数据归集项配置
    //   return request({
    //     url: `/job-web/job-metas/search`,
    //     method: 'post',
    //     data,
    //   })
    // },
    // jobmetasdetailApi: (data?: dataCollectionType) => {//查询所有数据归集项详情
    //   return request({
    //     url: `/job-web/job-metas/${data?.id}`,
    //     method: 'get',
    //     data,
    //   })
    // },
    // jobmetasdeleteApi: (data?: dataCollectionType) => {//数据归集项配置删除
    //   console.log('data66', data)
    //   return request({
    //     url: `/job-web/job-metas/simple/${data?.id}`,
    //     method: 'delete',
    //     data,
    //   })
    // },
    // jobmetasPublishApi: (data?: dataCollectionType) => {//数据归集项配置删除
    //   console.log('data77', data)
    //   return request({
    //     url: `/job-web/jobs/jar-run/${data?.id}`,
    //     method: 'post',
    //   })
    // },
    // sourcesinkjdbcAddApi: (data?: object) => {//目标数据库配置新增
    //   return request({
    //     url: `/job-web/source-sink/jdbc`,
    //     method: 'post',
    //     data,
    //   })
    // },
    // sourcesinkjdbcEditApi: (data?: targetDataType) => {//目标数据库配置修改
    //   console.log('data55', data)
    //   return request({
    //     url: `/job-web/source-sink/jdbc/${data?.id}`,
    //     method: 'put',
    //     data,
    //   })
    // },



  }
}