'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var shared = require('@vue/shared');
var lodashUnified = require('lodash-unified');
var core = require('@vueuse/core');
var index = require('../../cascader-panel/index.js');
var index$1 = require('../../input/index.js');
var index$2 = require('../../tooltip/index.js');
var index$3 = require('../../scrollbar/index.js');
var index$4 = require('../../tag/index.js');
var index$5 = require('../../icon/index.js');
require('../../../directives/index.js');
require('../../../hooks/index.js');
require('../../../utils/index.js');
require('../../../constants/index.js');
var iconsVue = require('@element-plus/icons-vue');
var pluginVue_exportHelper = require('../../../_virtual/plugin-vue_export-helper.js');
var index$6 = require('../../../directives/click-outside/index.js');
var config = require('../../cascader-panel/src/config.js');
var validator = require('../../../utils/vue/validator.js');
var content = require('../../tooltip/src/content.js');
var tag = require('../../tag/src/tag.js');
var event = require('../../../constants/event.js');
var index$7 = require('../../../hooks/use-namespace/index.js');
var index$8 = require('../../../hooks/use-locale/index.js');
var index$9 = require('../../../hooks/use-form-item/index.js');
var index$a = require('../../../hooks/use-common-props/index.js');
var error = require('../../../utils/error.js');
var i18n = require('../../../utils/i18n.js');
var aria = require('../../../constants/aria.js');
var aria$1 = require('../../../utils/dom/aria.js');

const DEFAULT_INPUT_HEIGHT = 40;
const INPUT_HEIGHT_MAP = {
  large: 36,
  default: 32,
  small: 28
};
const popperOptions = {
  modifiers: [
    {
      name: "arrowPosition",
      enabled: true,
      phase: "main",
      fn: ({ state }) => {
        const { modifiersData, placement } = state;
        if (["right", "left", "bottom", "top"].includes(placement))
          return;
        modifiersData.arrow.x = 35;
      },
      requires: ["arrow"]
    }
  ]
};
const COMPONENT_NAME = "ElCascader";
const _sfc_main = vue.defineComponent({
  name: COMPONENT_NAME,
  components: {
    ElCascaderPanel: index["default"],
    ElInput: index$1.ElInput,
    ElTooltip: index$2.ElTooltip,
    ElScrollbar: index$3.ElScrollbar,
    ElTag: index$4.ElTag,
    ElIcon: index$5.ElIcon,
    CircleClose: iconsVue.CircleClose,
    Check: iconsVue.Check,
    ArrowDown: iconsVue.ArrowDown
  },
  directives: {
    Clickoutside: index$6["default"]
  },
  props: {
    ...config.CommonProps,
    size: {
      type: String,
      validator: validator.isValidComponentSize
    },
    placeholder: {
      type: String
    },
    disabled: Boolean,
    clearable: Boolean,
    filterable: Boolean,
    filterMethod: {
      type: Function,
      default: (node, keyword) => node.text.includes(keyword)
    },
    separator: {
      type: String,
      default: " / "
    },
    showAllLevels: {
      type: Boolean,
      default: true
    },
    collapseTags: Boolean,
    collapseTagsTooltip: {
      type: Boolean,
      default: false
    },
    debounce: {
      type: Number,
      default: 300
    },
    beforeFilter: {
      type: Function,
      default: () => true
    },
    popperClass: {
      type: String,
      default: ""
    },
    teleported: content.useTooltipContentProps.teleported,
    tagType: { ...tag.tagProps.type, default: "info" },
    validateEvent: {
      type: Boolean,
      default: true
    }
  },
  emits: [
    event.UPDATE_MODEL_EVENT,
    event.CHANGE_EVENT,
    "focus",
    "blur",
    "visible-change",
    "expand-change",
    "remove-tag"
  ],
  setup(props, { emit }) {
    let inputInitialHeight = 0;
    let pressDeleteCount = 0;
    const nsCascader = index$7.useNamespace("cascader");
    const nsInput = index$7.useNamespace("input");
    const { t } = index$8.useLocale();
    const { form, formItem } = index$9.useFormItem();
    const tooltipRef = vue.ref(null);
    const input = vue.ref(null);
    const tagWrapper = vue.ref(null);
    const panel = vue.ref(null);
    const suggestionPanel = vue.ref(null);
    const popperVisible = vue.ref(false);
    const inputHover = vue.ref(false);
    const filtering = vue.ref(false);
    const inputValue = vue.ref("");
    const searchInputValue = vue.ref("");
    const presentTags = vue.ref([]);
    const allPresentTags = vue.ref([]);
    const suggestions = vue.ref([]);
    const isOnComposition = vue.ref(false);
    const isDisabled = vue.computed(() => props.disabled || (form == null ? void 0 : form.disabled));
    const inputPlaceholder = vue.computed(() => props.placeholder || t("el.cascader.placeholder"));
    const realSize = index$a.useSize();
    const tagSize = vue.computed(() => ["small"].includes(realSize.value) ? "small" : "default");
    const multiple = vue.computed(() => !!props.props.multiple);
    const readonly = vue.computed(() => !props.filterable || multiple.value);
    const searchKeyword = vue.computed(() => multiple.value ? searchInputValue.value : inputValue.value);
    const checkedNodes = vue.computed(() => {
      var _a;
      return ((_a = panel.value) == null ? void 0 : _a.checkedNodes) || [];
    });
    const clearBtnVisible = vue.computed(() => {
      if (!props.clearable || isDisabled.value || filtering.value || !inputHover.value)
        return false;
      return !!checkedNodes.value.length;
    });
    const presentText = vue.computed(() => {
      const { showAllLevels, separator } = props;
      const nodes = checkedNodes.value;
      return nodes.length ? multiple.value ? " " : nodes[0].calcText(showAllLevels, separator) : "";
    });
    const checkedValue = vue.computed({
      get() {
        return props.modelValue;
      },
      set(val) {
        emit(event.UPDATE_MODEL_EVENT, val);
        emit(event.CHANGE_EVENT, val);
        if (props.validateEvent) {
          formItem == null ? void 0 : formItem.validate("change").catch((err) => error.debugWarn(err));
        }
      }
    });
    const popperPaneRef = vue.computed(() => {
      var _a, _b;
      return (_b = (_a = tooltipRef.value) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.contentRef;
    });
    const togglePopperVisible = (visible) => {
      var _a, _b, _c;
      if (isDisabled.value)
        return;
      visible = visible != null ? visible : !popperVisible.value;
      if (visible !== popperVisible.value) {
        popperVisible.value = visible;
        (_b = (_a = input.value) == null ? void 0 : _a.input) == null ? void 0 : _b.setAttribute("aria-expanded", `${visible}`);
        if (visible) {
          updatePopperPosition();
          vue.nextTick((_c = panel.value) == null ? void 0 : _c.scrollToExpandingNode);
        } else if (props.filterable) {
          syncPresentTextValue();
        }
        emit("visible-change", visible);
      }
    };
    const updatePopperPosition = () => {
      vue.nextTick(() => {
        var _a;
        (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper();
      });
    };
    const hideSuggestionPanel = () => {
      filtering.value = false;
    };
    const genTag = (node) => {
      const { showAllLevels, separator } = props;
      return {
        node,
        key: node.uid,
        text: node.calcText(showAllLevels, separator),
        hitState: false,
        closable: !isDisabled.value && !node.isDisabled,
        isCollapseTag: false
      };
    };
    const deleteTag = (tag) => {
      var _a;
      const node = tag.node;
      node.doCheck(false);
      (_a = panel.value) == null ? void 0 : _a.calculateCheckedValue();
      emit("remove-tag", node.valueByOption);
    };
    const calculatePresentTags = () => {
      if (!multiple.value)
        return;
      const nodes = checkedNodes.value;
      const tags = [];
      const allTags = [];
      nodes.forEach((node) => allTags.push(genTag(node)));
      allPresentTags.value = allTags;
      if (nodes.length) {
        const [first, ...rest] = nodes;
        const restCount = rest.length;
        tags.push(genTag(first));
        if (restCount) {
          if (props.collapseTags) {
            tags.push({
              key: -1,
              text: `+ ${restCount}`,
              closable: false,
              isCollapseTag: true
            });
          } else {
            rest.forEach((node) => tags.push(genTag(node)));
          }
        }
      }
      presentTags.value = tags;
    };
    const calculateSuggestions = () => {
      var _a, _b;
      const { filterMethod, showAllLevels, separator } = props;
      const res = (_b = (_a = panel.value) == null ? void 0 : _a.getFlattedNodes(!props.props.checkStrictly)) == null ? void 0 : _b.filter((node) => {
        if (node.isDisabled)
          return false;
        node.calcText(showAllLevels, separator);
        return filterMethod(node, searchKeyword.value);
      });
      if (multiple.value) {
        presentTags.value.forEach((tag) => {
          tag.hitState = false;
        });
        allPresentTags.value.forEach((tag) => {
          tag.hitState = false;
        });
      }
      filtering.value = true;
      suggestions.value = res;
      updatePopperPosition();
    };
    const focusFirstNode = () => {
      var _a;
      let firstNode;
      if (filtering.value && suggestionPanel.value) {
        firstNode = suggestionPanel.value.$el.querySelector(`.${nsCascader.e("suggestion-item")}`);
      } else {
        firstNode = (_a = panel.value) == null ? void 0 : _a.$el.querySelector(`.${nsCascader.b("node")}[tabindex="-1"]`);
      }
      if (firstNode) {
        firstNode.focus();
        !filtering.value && firstNode.click();
      }
    };
    const updateStyle = () => {
      var _a, _b;
      const inputInner = (_a = input.value) == null ? void 0 : _a.input;
      const tagWrapperEl = tagWrapper.value;
      const suggestionPanelEl = (_b = suggestionPanel.value) == null ? void 0 : _b.$el;
      if (!core.isClient || !inputInner)
        return;
      if (suggestionPanelEl) {
        const suggestionList = suggestionPanelEl.querySelector(`.${nsCascader.e("suggestion-list")}`);
        suggestionList.style.minWidth = `${inputInner.offsetWidth}px`;
      }
      if (tagWrapperEl) {
        const { offsetHeight } = tagWrapperEl;
        const height = presentTags.value.length > 0 ? `${Math.max(offsetHeight + 6, inputInitialHeight)}px` : `${inputInitialHeight}px`;
        inputInner.style.height = height;
        updatePopperPosition();
      }
    };
    const getCheckedNodes = (leafOnly) => {
      var _a;
      return (_a = panel.value) == null ? void 0 : _a.getCheckedNodes(leafOnly);
    };
    const handleExpandChange = (value) => {
      updatePopperPosition();
      emit("expand-change", value);
    };
    const handleComposition = (event) => {
      var _a;
      const text = (_a = event.target) == null ? void 0 : _a.value;
      if (event.type === "compositionend") {
        isOnComposition.value = false;
        vue.nextTick(() => handleInput(text));
      } else {
        const lastCharacter = text[text.length - 1] || "";
        isOnComposition.value = !i18n.isKorean(lastCharacter);
      }
    };
    const handleKeyDown = (e) => {
      if (isOnComposition.value)
        return;
      switch (e.code) {
        case aria.EVENT_CODE.enter:
          togglePopperVisible();
          break;
        case aria.EVENT_CODE.down:
          togglePopperVisible(true);
          vue.nextTick(focusFirstNode);
          e.preventDefault();
          break;
        case aria.EVENT_CODE.esc:
          if (popperVisible.value === true) {
            e.preventDefault();
            e.stopPropagation();
            togglePopperVisible(false);
          }
          break;
        case aria.EVENT_CODE.tab:
          togglePopperVisible(false);
          break;
      }
    };
    const handleClear = () => {
      var _a;
      (_a = panel.value) == null ? void 0 : _a.clearCheckedNodes();
      if (!popperVisible.value && props.filterable) {
        syncPresentTextValue();
      }
      togglePopperVisible(false);
    };
    const syncPresentTextValue = () => {
      const { value } = presentText;
      inputValue.value = value;
      searchInputValue.value = value;
    };
    const handleSuggestionClick = (node) => {
      var _a, _b;
      const { checked } = node;
      if (multiple.value) {
        (_a = panel.value) == null ? void 0 : _a.handleCheckChange(node, !checked, false);
      } else {
        !checked && ((_b = panel.value) == null ? void 0 : _b.handleCheckChange(node, true, false));
        togglePopperVisible(false);
      }
    };
    const handleSuggestionKeyDown = (e) => {
      const target = e.target;
      const { code } = e;
      switch (code) {
        case aria.EVENT_CODE.up:
        case aria.EVENT_CODE.down: {
          const distance = code === aria.EVENT_CODE.up ? -1 : 1;
          aria$1.focusNode(aria$1.getSibling(target, distance, `.${nsCascader.e("suggestion-item")}[tabindex="-1"]`));
          break;
        }
        case aria.EVENT_CODE.enter:
          target.click();
          break;
      }
    };
    const handleDelete = () => {
      const tags = presentTags.value;
      const lastTag = tags[tags.length - 1];
      pressDeleteCount = searchInputValue.value ? 0 : pressDeleteCount + 1;
      if (!lastTag || !pressDeleteCount || props.collapseTags && tags.length > 1)
        return;
      if (lastTag.hitState) {
        deleteTag(lastTag);
      } else {
        lastTag.hitState = true;
      }
    };
    const handleFilter = lodashUnified.debounce(() => {
      const { value } = searchKeyword;
      if (!value)
        return;
      const passed = props.beforeFilter(value);
      if (shared.isPromise(passed)) {
        passed.then(calculateSuggestions).catch(() => {
        });
      } else if (passed !== false) {
        calculateSuggestions();
      } else {
        hideSuggestionPanel();
      }
    }, props.debounce);
    const handleInput = (val, e) => {
      !popperVisible.value && togglePopperVisible(true);
      if (e == null ? void 0 : e.isComposing)
        return;
      val ? handleFilter() : hideSuggestionPanel();
    };
    vue.watch(filtering, updatePopperPosition);
    vue.watch([checkedNodes, isDisabled], calculatePresentTags);
    vue.watch(presentTags, () => {
      vue.nextTick(() => updateStyle());
    });
    vue.watch(presentText, syncPresentTextValue, { immediate: true });
    vue.onMounted(() => {
      var _a;
      const inputEl = (_a = input.value) == null ? void 0 : _a.$el;
      inputInitialHeight = (inputEl == null ? void 0 : inputEl.offsetHeight) || INPUT_HEIGHT_MAP[realSize.value] || DEFAULT_INPUT_HEIGHT;
      core.useResizeObserver(inputEl, updateStyle);
    });
    return {
      popperOptions,
      tooltipRef,
      popperPaneRef,
      input,
      tagWrapper,
      panel,
      suggestionPanel,
      popperVisible,
      inputHover,
      inputPlaceholder,
      filtering,
      presentText,
      checkedValue,
      inputValue,
      searchInputValue,
      presentTags,
      allPresentTags,
      suggestions,
      isDisabled,
      isOnComposition,
      realSize,
      tagSize,
      multiple,
      readonly,
      clearBtnVisible,
      nsCascader,
      nsInput,
      t,
      togglePopperVisible,
      hideSuggestionPanel,
      deleteTag,
      focusFirstNode,
      getCheckedNodes,
      handleExpandChange,
      handleKeyDown,
      handleComposition,
      handleClear,
      handleSuggestionClick,
      handleSuggestionKeyDown,
      handleDelete,
      handleInput
    };
  }
});
const _hoisted_1 = { key: 0 };
const _hoisted_2 = ["placeholder"];
const _hoisted_3 = ["onClick"];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_circle_close = vue.resolveComponent("circle-close");
  const _component_el_icon = vue.resolveComponent("el-icon");
  const _component_arrow_down = vue.resolveComponent("arrow-down");
  const _component_el_input = vue.resolveComponent("el-input");
  const _component_el_tag = vue.resolveComponent("el-tag");
  const _component_el_tooltip = vue.resolveComponent("el-tooltip");
  const _component_el_cascader_panel = vue.resolveComponent("el-cascader-panel");
  const _component_check = vue.resolveComponent("check");
  const _component_el_scrollbar = vue.resolveComponent("el-scrollbar");
  const _directive_clickoutside = vue.resolveDirective("clickoutside");
  return vue.openBlock(), vue.createBlock(_component_el_tooltip, {
    ref: "tooltipRef",
    visible: _ctx.popperVisible,
    teleported: _ctx.teleported,
    "popper-class": [_ctx.nsCascader.e("dropdown"), _ctx.popperClass],
    "popper-options": _ctx.popperOptions,
    "fallback-placements": [
      "bottom-start",
      "bottom",
      "top-start",
      "top",
      "right",
      "left"
    ],
    "stop-popper-mouse-event": false,
    "gpu-acceleration": false,
    placement: "bottom-start",
    transition: `${_ctx.nsCascader.namespace.value}-zoom-in-top`,
    effect: "light",
    pure: "",
    persistent: "",
    onHide: _ctx.hideSuggestionPanel
  }, {
    default: vue.withCtx(() => [
      vue.withDirectives((vue.openBlock(), vue.createElementBlock("div", {
        class: vue.normalizeClass([
          _ctx.nsCascader.b(),
          _ctx.nsCascader.m(_ctx.realSize),
          _ctx.nsCascader.is("disabled", _ctx.isDisabled),
          _ctx.$attrs.class
        ]),
        style: vue.normalizeStyle(_ctx.$attrs.style),
        onClick: _cache[11] || (_cache[11] = () => _ctx.togglePopperVisible(_ctx.readonly ? void 0 : true)),
        onKeydown: _cache[12] || (_cache[12] = (...args) => _ctx.handleKeyDown && _ctx.handleKeyDown(...args)),
        onMouseenter: _cache[13] || (_cache[13] = ($event) => _ctx.inputHover = true),
        onMouseleave: _cache[14] || (_cache[14] = ($event) => _ctx.inputHover = false)
      }, [
        vue.createVNode(_component_el_input, {
          ref: "input",
          modelValue: _ctx.inputValue,
          "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => _ctx.inputValue = $event),
          placeholder: _ctx.searchInputValue ? "" : _ctx.inputPlaceholder,
          readonly: _ctx.readonly,
          disabled: _ctx.isDisabled,
          "validate-event": false,
          size: _ctx.realSize,
          class: vue.normalizeClass(_ctx.nsCascader.is("focus", _ctx.popperVisible)),
          onCompositionstart: _ctx.handleComposition,
          onCompositionupdate: _ctx.handleComposition,
          onCompositionend: _ctx.handleComposition,
          onFocus: _cache[2] || (_cache[2] = (e) => _ctx.$emit("focus", e)),
          onBlur: _cache[3] || (_cache[3] = (e) => _ctx.$emit("blur", e)),
          onInput: _ctx.handleInput
        }, {
          suffix: vue.withCtx(() => [
            _ctx.clearBtnVisible ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
              key: "clear",
              class: vue.normalizeClass([_ctx.nsInput.e("icon"), "icon-circle-close"]),
              onClick: vue.withModifiers(_ctx.handleClear, ["stop"])
            }, {
              default: vue.withCtx(() => [
                vue.createVNode(_component_circle_close)
              ]),
              _: 1
            }, 8, ["class", "onClick"])) : (vue.openBlock(), vue.createBlock(_component_el_icon, {
              key: "arrow-down",
              class: vue.normalizeClass([
                _ctx.nsInput.e("icon"),
                "icon-arrow-down",
                _ctx.nsCascader.is("reverse", _ctx.popperVisible)
              ]),
              onClick: _cache[0] || (_cache[0] = vue.withModifiers(($event) => _ctx.togglePopperVisible(), ["stop"]))
            }, {
              default: vue.withCtx(() => [
                vue.createVNode(_component_arrow_down)
              ]),
              _: 1
            }, 8, ["class"]))
          ]),
          _: 1
        }, 8, ["modelValue", "placeholder", "readonly", "disabled", "size", "class", "onCompositionstart", "onCompositionupdate", "onCompositionend", "onInput"]),
        _ctx.multiple ? (vue.openBlock(), vue.createElementBlock("div", {
          key: 0,
          ref: "tagWrapper",
          class: vue.normalizeClass(_ctx.nsCascader.e("tags"))
        }, [
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.presentTags, (tag) => {
            return vue.openBlock(), vue.createBlock(_component_el_tag, {
              key: tag.key,
              type: _ctx.tagType,
              size: _ctx.tagSize,
              hit: tag.hitState,
              closable: tag.closable,
              "disable-transitions": "",
              onClose: ($event) => _ctx.deleteTag(tag)
            }, {
              default: vue.withCtx(() => [
                tag.isCollapseTag === false ? (vue.openBlock(), vue.createElementBlock("span", _hoisted_1, vue.toDisplayString(tag.text), 1)) : (vue.openBlock(), vue.createBlock(_component_el_tooltip, {
                  key: 1,
                  teleported: false,
                  disabled: _ctx.popperVisible || !_ctx.collapseTagsTooltip,
                  "fallback-placements": ["bottom", "top", "right", "left"],
                  placement: "bottom",
                  effect: "light"
                }, {
                  default: vue.withCtx(() => [
                    vue.createElementVNode("span", null, vue.toDisplayString(tag.text), 1)
                  ]),
                  content: vue.withCtx(() => [
                    vue.createElementVNode("div", {
                      class: vue.normalizeClass(_ctx.nsCascader.e("collapse-tags"))
                    }, [
                      (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.allPresentTags.slice(1), (tag2, idx) => {
                        return vue.openBlock(), vue.createElementBlock("div", {
                          key: idx,
                          class: vue.normalizeClass(_ctx.nsCascader.e("collapse-tag"))
                        }, [
                          (vue.openBlock(), vue.createBlock(_component_el_tag, {
                            key: tag2.key,
                            class: "in-tooltip",
                            type: _ctx.tagType,
                            size: _ctx.tagSize,
                            hit: tag2.hitState,
                            closable: tag2.closable,
                            "disable-transitions": "",
                            onClose: ($event) => _ctx.deleteTag(tag2)
                          }, {
                            default: vue.withCtx(() => [
                              vue.createElementVNode("span", null, vue.toDisplayString(tag2.text), 1)
                            ]),
                            _: 2
                          }, 1032, ["type", "size", "hit", "closable", "onClose"]))
                        ], 2);
                      }), 128))
                    ], 2)
                  ]),
                  _: 2
                }, 1032, ["disabled"]))
              ]),
              _: 2
            }, 1032, ["type", "size", "hit", "closable", "onClose"]);
          }), 128)),
          _ctx.filterable && !_ctx.isDisabled ? vue.withDirectives((vue.openBlock(), vue.createElementBlock("input", {
            key: 0,
            "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => _ctx.searchInputValue = $event),
            type: "text",
            class: vue.normalizeClass(_ctx.nsCascader.e("search-input")),
            placeholder: _ctx.presentText ? "" : _ctx.inputPlaceholder,
            onInput: _cache[5] || (_cache[5] = (e) => _ctx.handleInput(_ctx.searchInputValue, e)),
            onClick: _cache[6] || (_cache[6] = vue.withModifiers(($event) => _ctx.togglePopperVisible(true), ["stop"])),
            onKeydown: _cache[7] || (_cache[7] = vue.withKeys((...args) => _ctx.handleDelete && _ctx.handleDelete(...args), ["delete"])),
            onCompositionstart: _cache[8] || (_cache[8] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
            onCompositionupdate: _cache[9] || (_cache[9] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
            onCompositionend: _cache[10] || (_cache[10] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args))
          }, null, 42, _hoisted_2)), [
            [vue.vModelText, _ctx.searchInputValue]
          ]) : vue.createCommentVNode("v-if", true)
        ], 2)) : vue.createCommentVNode("v-if", true)
      ], 38)), [
        [_directive_clickoutside, () => _ctx.togglePopperVisible(false), _ctx.popperPaneRef]
      ])
    ]),
    content: vue.withCtx(() => [
      vue.withDirectives(vue.createVNode(_component_el_cascader_panel, {
        ref: "panel",
        modelValue: _ctx.checkedValue,
        "onUpdate:modelValue": _cache[15] || (_cache[15] = ($event) => _ctx.checkedValue = $event),
        options: _ctx.options,
        props: _ctx.props,
        border: false,
        "render-label": _ctx.$slots.default,
        onExpandChange: _ctx.handleExpandChange,
        onClose: _cache[16] || (_cache[16] = ($event) => _ctx.$nextTick(() => _ctx.togglePopperVisible(false)))
      }, null, 8, ["modelValue", "options", "props", "render-label", "onExpandChange"]), [
        [vue.vShow, !_ctx.filtering]
      ]),
      _ctx.filterable ? vue.withDirectives((vue.openBlock(), vue.createBlock(_component_el_scrollbar, {
        key: 0,
        ref: "suggestionPanel",
        tag: "ul",
        class: vue.normalizeClass(_ctx.nsCascader.e("suggestion-panel")),
        "view-class": _ctx.nsCascader.e("suggestion-list"),
        onKeydown: _ctx.handleSuggestionKeyDown
      }, {
        default: vue.withCtx(() => [
          _ctx.suggestions.length ? (vue.openBlock(true), vue.createElementBlock(vue.Fragment, { key: 0 }, vue.renderList(_ctx.suggestions, (item) => {
            return vue.openBlock(), vue.createElementBlock("li", {
              key: item.uid,
              class: vue.normalizeClass([
                _ctx.nsCascader.e("suggestion-item"),
                _ctx.nsCascader.is("checked", item.checked)
              ]),
              tabindex: -1,
              onClick: ($event) => _ctx.handleSuggestionClick(item)
            }, [
              vue.createElementVNode("span", null, vue.toDisplayString(item.text), 1),
              item.checked ? (vue.openBlock(), vue.createBlock(_component_el_icon, { key: 0 }, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_check)
                ]),
                _: 1
              })) : vue.createCommentVNode("v-if", true)
            ], 10, _hoisted_3);
          }), 128)) : vue.renderSlot(_ctx.$slots, "empty", { key: 1 }, () => [
            vue.createElementVNode("li", {
              class: vue.normalizeClass(_ctx.nsCascader.e("empty-text"))
            }, vue.toDisplayString(_ctx.t("el.cascader.noMatch")), 3)
          ])
        ]),
        _: 3
      }, 8, ["class", "view-class", "onKeydown"])), [
        [vue.vShow, _ctx.filtering]
      ]) : vue.createCommentVNode("v-if", true)
    ]),
    _: 3
  }, 8, ["visible", "teleported", "popper-class", "popper-options", "transition", "onHide"]);
}
var Cascader = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["render", _sfc_render], ["__file", "/home/runner/work/element-plus/element-plus/packages/components/cascader/src/index.vue"]]);

exports["default"] = Cascader;
//# sourceMappingURL=index.js.map
