Object.defineProperty(exports, "__esModule", { value: true });
exports.baseCompile = exports.compile = void 0;
const CompilerDom = require("@vue/compiler-dom");
const CompilerCore = require("@vue/compiler-core");
function compile(template, options = {}) {
    const onError = options.onError;
    options.onError = (error) => {
        if (error.code === 33 /* CompilerCore.ErrorCodes.X_V_FOR_TEMPLATE_KEY_PLACEMENT */ // :key binding allowed in v-for template child in vue 2
            || error.code === 29 /* CompilerCore.ErrorCodes.X_V_IF_SAME_KEY */ // fix https://github.com/johnsoncodehk/volar/issues/1638
        ) {
            return;
        }
        if (onError) {
            onError(error);
        }
        else {
            throw error;
        }
    };
    return baseCompile(template, Object.assign({}, CompilerDom.parserOptions, options, {
        nodeTransforms: [
            ...CompilerDom.DOMNodeTransforms,
            ...(options.nodeTransforms || [])
        ],
        directiveTransforms: Object.assign({}, CompilerDom.DOMDirectiveTransforms, options.directiveTransforms || {}),
    }));
}
exports.compile = compile;
function baseCompile(template, options = {}) {
    const onError = options.onError || ((error) => { throw error; });
    const isModuleMode = options.mode === 'module';
    const prefixIdentifiers = options.prefixIdentifiers === true || isModuleMode;
    if (!prefixIdentifiers && options.cacheHandlers) {
        onError(CompilerCore.createCompilerError(48 /* CompilerCore.ErrorCodes.X_CACHE_HANDLER_NOT_SUPPORTED */));
    }
    if (options.scopeId && !isModuleMode) {
        onError(CompilerCore.createCompilerError(49 /* CompilerCore.ErrorCodes.X_SCOPE_ID_NOT_SUPPORTED */));
    }
    const ast = CompilerCore.baseParse(template, options);
    const [nodeTransforms, directiveTransforms] = CompilerCore.getBaseTransformPreset(prefixIdentifiers);
    // v-for > v-if in vue 2
    const transformIf = nodeTransforms[1];
    const transformFor = nodeTransforms[3];
    nodeTransforms[1] = transformFor;
    nodeTransforms[3] = transformIf;
    CompilerCore.transform(ast, Object.assign({}, options, {
        prefixIdentifiers,
        nodeTransforms: [
            ...nodeTransforms,
            ...(options.nodeTransforms || []) // user transforms
        ],
        directiveTransforms: Object.assign({}, directiveTransforms, options.directiveTransforms || {} // user transforms
        )
    }));
    return CompilerCore.generate(ast, Object.assign({}, options, {
        prefixIdentifiers
    }));
}
exports.baseCompile = baseCompile;
//# sourceMappingURL=vue2TemplateCompiler.js.map