Object.defineProperty(exports, "__esModule", { value: true });
exports.getVueCompilerOptions = exports.createParsedCommandLine = exports.createParsedCommandLineByJson = void 0;
const path_1 = require("path");
function createParsedCommandLineByJson(ts, parseConfigHost, rootDir, json) {
    const tsConfigPath = path_1.posix.join(rootDir, 'jsconfig.json');
    const content = ts.parseJsonConfigFileContent(json, parseConfigHost, rootDir, {}, tsConfigPath);
    return createParsedCommandLineBase(ts, parseConfigHost, content, tsConfigPath, new Set());
}
exports.createParsedCommandLineByJson = createParsedCommandLineByJson;
function createParsedCommandLine(ts, parseConfigHost, tsConfigPath, extendsSet = new Set()) {
    const config = ts.readJsonConfigFile(tsConfigPath, parseConfigHost.readFile);
    const content = ts.parseJsonSourceFileConfigFileContent(config, parseConfigHost, path_1.posix.dirname(tsConfigPath), {}, path_1.posix.basename(tsConfigPath));
    // fix https://github.com/johnsoncodehk/volar/issues/1786
    // https://github.com/microsoft/TypeScript/issues/30457
    // patching ts server broke with outDir + rootDir + composite/incremental
    content.options.outDir = undefined;
    return createParsedCommandLineBase(ts, parseConfigHost, content, tsConfigPath, extendsSet);
}
exports.createParsedCommandLine = createParsedCommandLine;
function createParsedCommandLineBase(ts, parseConfigHost, content, tsConfigPath, extendsSet) {
    var _a;
    let baseVueOptions = {};
    const folder = path_1.posix.dirname(tsConfigPath);
    extendsSet.add(tsConfigPath);
    if (content.raw.extends) {
        try {
            const extendsPath = require.resolve(content.raw.extends, { paths: [folder] });
            if (!extendsSet.has(extendsPath)) {
                baseVueOptions = createParsedCommandLine(ts, parseConfigHost, extendsPath, extendsSet).vueOptions;
            }
        }
        catch (error) {
            console.error(error);
        }
    }
    return Object.assign(Object.assign({}, content), { vueOptions: Object.assign(Object.assign({}, baseVueOptions), resolveVueCompilerOptions((_a = content.raw.vueCompilerOptions) !== null && _a !== void 0 ? _a : {}, folder)) });
}
function getVueCompilerOptions(vueOptions) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
    const target = (_a = vueOptions.target) !== null && _a !== void 0 ? _a : 3;
    return Object.assign(Object.assign({}, vueOptions), { target, strictTemplates: (_b = vueOptions.strictTemplates) !== null && _b !== void 0 ? _b : false, plugins: (_c = vueOptions.plugins) !== null && _c !== void 0 ? _c : [], 
        // experimental
        experimentalComponentOptionsWrapper: (_d = vueOptions.experimentalComponentOptionsWrapper) !== null && _d !== void 0 ? _d : (target >= 2.7
            ? [`(await import('vue')).defineComponent(`, `)`]
            : [`(await import('vue')).default.extend(`, `)`]), experimentalComponentOptionsWrapperEnable: (_e = vueOptions.experimentalComponentOptionsWrapperEnable) !== null && _e !== void 0 ? _e : 'onlyJs', experimentalRuntimeMode: (_f = vueOptions.experimentalRuntimeMode) !== null && _f !== void 0 ? _f : 'runtime-dom', experimentalDowngradePropsAndEmitsToSetupReturnOnScriptSetup: (_g = vueOptions.experimentalDowngradePropsAndEmitsToSetupReturnOnScriptSetup) !== null && _g !== void 0 ? _g : 'onlyJs', experimentalTemplateCompilerOptions: (_h = vueOptions.experimentalTemplateCompilerOptions) !== null && _h !== void 0 ? _h : {}, experimentalTemplateCompilerOptionsRequirePath: (_j = vueOptions.experimentalTemplateCompilerOptionsRequirePath) !== null && _j !== void 0 ? _j : undefined, experimentalDisableTemplateSupport: (_k = vueOptions.experimentalDisableTemplateSupport) !== null && _k !== void 0 ? _k : false, experimentalResolveStyleCssClasses: (_l = vueOptions.experimentalResolveStyleCssClasses) !== null && _l !== void 0 ? _l : 'scoped', experimentalAllowTypeNarrowingInInlineHandlers: (_m = vueOptions.experimentalAllowTypeNarrowingInInlineHandlers) !== null && _m !== void 0 ? _m : false });
}
exports.getVueCompilerOptions = getVueCompilerOptions;
function resolveVueCompilerOptions(rawOptions, rootPath) {
    const result = Object.assign({}, rawOptions);
    let templateOptionsPath = rawOptions.experimentalTemplateCompilerOptionsRequirePath;
    if (templateOptionsPath) {
        if (!path_1.posix.isAbsolute(templateOptionsPath)) {
            templateOptionsPath = require.resolve(templateOptionsPath, { paths: [rootPath] });
        }
        try {
            result.experimentalTemplateCompilerOptions = require(templateOptionsPath).default;
        }
        catch (error) {
            console.warn('Failed to require "experimentalTemplateCompilerOptionsRequirePath":', templateOptionsPath);
            console.error(error);
        }
    }
    return result;
}
//# sourceMappingURL=ts.js.map